<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Payments ServiceType
 * @subpackage Services
 */
class Payments extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Payments_GetFleets
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el listado de flotas asociadas a un operador de pagos. Exclusivo para operadores de pago.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payments_GetFleets $parameters
     * @return \StructType\Payments_GetFleetsResponse|bool
     */
    public function Payments_GetFleets(\StructType\Payments_GetFleets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Payments_GetFleets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Payments_GetFleetRoutes
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el listado de rutas de una flotas. Exclusivo para operadores de pago.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payments_GetFleetRoutes $parameters
     * @return \StructType\Payments_GetFleetRoutesResponse|bool
     */
    public function Payments_GetFleetRoutes(\StructType\Payments_GetFleetRoutes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Payments_GetFleetRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Payments_GetFleetVehicles
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el listado de vehículos de una flotas. Exclusivo para operadores de pago.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payments_GetFleetVehicles $parameters
     * @return \StructType\Payments_GetFleetVehiclesResponse|bool
     */
    public function Payments_GetFleetVehicles(\StructType\Payments_GetFleetVehicles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Payments_GetFleetVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Payments_GetFleetTransferGeofences
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el listado de zonas de transferencia de una flotas. Exclusivo para operadores de pago.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payments_GetFleetTransferGeofences $parameters
     * @return \StructType\Payments_GetFleetTransferGeofencesResponse|bool
     */
    public function Payments_GetFleetTransferGeofences(\StructType\Payments_GetFleetTransferGeofences $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Payments_GetFleetTransferGeofences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Payments_GetFleetDrivers
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el listado de conductores de una flotas. Exclusivo para operadores de pago.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payments_GetFleetDrivers $parameters
     * @return \StructType\Payments_GetFleetDriversResponse|bool
     */
    public function Payments_GetFleetDrivers(\StructType\Payments_GetFleetDrivers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Payments_GetFleetDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Payments_GetFleetDriversResponse|\StructType\Payments_GetFleetRoutesResponse|\StructType\Payments_GetFleetsResponse|\StructType\Payments_GetFleetTransferGeofencesResponse|\StructType\Payments_GetFleetVehiclesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
