<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_Driver StructType
 * @subpackage Structs
 */
class Payments_Driver extends AbstractStructBase
{
    /**
     * The DriverId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverId;
    /**
     * The DriverDocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverDocType;
    /**
     * The DriverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverName;
    /**
     * The DriverDoc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDoc;
    /**
     * Constructor method for Payments_Driver
     * @uses Payments_Driver::setDriverId()
     * @uses Payments_Driver::setDriverDocType()
     * @uses Payments_Driver::setDriverName()
     * @uses Payments_Driver::setDriverDoc()
     * @param int $driverId
     * @param int $driverDocType
     * @param string $driverName
     * @param string $driverDoc
     */
    public function __construct($driverId = null, $driverDocType = null, $driverName = null, $driverDoc = null)
    {
        $this
            ->setDriverId($driverId)
            ->setDriverDocType($driverDocType)
            ->setDriverName($driverName)
            ->setDriverDoc($driverDoc);
    }
    /**
     * Get DriverId value
     * @return int
     */
    public function getDriverId()
    {
        return $this->DriverId;
    }
    /**
     * Set DriverId value
     * @param int $driverId
     * @return \StructType\Payments_Driver
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: int
        if (!is_null($driverId) && !(is_int($driverId) || ctype_digit($driverId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverId, true), gettype($driverId)), __LINE__);
        }
        $this->DriverId = $driverId;
        return $this;
    }
    /**
     * Get DriverDocType value
     * @return int
     */
    public function getDriverDocType()
    {
        return $this->DriverDocType;
    }
    /**
     * Set DriverDocType value
     * @param int $driverDocType
     * @return \StructType\Payments_Driver
     */
    public function setDriverDocType($driverDocType = null)
    {
        // validation for constraint: int
        if (!is_null($driverDocType) && !(is_int($driverDocType) || ctype_digit($driverDocType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverDocType, true), gettype($driverDocType)), __LINE__);
        }
        $this->DriverDocType = $driverDocType;
        return $this;
    }
    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }
    /**
     * Set DriverName value
     * @param string $driverName
     * @return \StructType\Payments_Driver
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }
    /**
     * Get DriverDoc value
     * @return string|null
     */
    public function getDriverDoc()
    {
        return $this->DriverDoc;
    }
    /**
     * Set DriverDoc value
     * @param string $driverDoc
     * @return \StructType\Payments_Driver
     */
    public function setDriverDoc($driverDoc = null)
    {
        // validation for constraint: string
        if (!is_null($driverDoc) && !is_string($driverDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDoc, true), gettype($driverDoc)), __LINE__);
        }
        $this->DriverDoc = $driverDoc;
        return $this;
    }
}
