<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Point StructType
 * @subpackage Structs
 */
class Point extends AbstractStructBase
{
    /**
     * The x
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $x;
    /**
     * The y
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $y;
    /**
     * The z
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $z;
    /**
     * Constructor method for Point
     * @uses Point::setX()
     * @uses Point::setY()
     * @uses Point::setZ()
     * @param float $x
     * @param float $y
     * @param float $z
     */
    public function __construct($x = null, $y = null, $z = null)
    {
        $this
            ->setX($x)
            ->setY($y)
            ->setZ($z);
    }
    /**
     * Get x value
     * @return float
     */
    public function getX()
    {
        return $this->x;
    }
    /**
     * Set x value
     * @param float $x
     * @return \StructType\Point
     */
    public function setX($x = null)
    {
        // validation for constraint: float
        if (!is_null($x) && !(is_float($x) || is_numeric($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->x = $x;
        return $this;
    }
    /**
     * Get y value
     * @return float
     */
    public function getY()
    {
        return $this->y;
    }
    /**
     * Set y value
     * @param float $y
     * @return \StructType\Point
     */
    public function setY($y = null)
    {
        // validation for constraint: float
        if (!is_null($y) && !(is_float($y) || is_numeric($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->y = $y;
        return $this;
    }
    /**
     * Get z value
     * @return float
     */
    public function getZ()
    {
        return $this->z;
    }
    /**
     * Set z value
     * @param float $z
     * @return \StructType\Point
     */
    public function setZ($z = null)
    {
        // validation for constraint: float
        if (!is_null($z) && !(is_float($z) || is_numeric($z))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($z, true), gettype($z)), __LINE__);
        }
        $this->z = $z;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Point
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
