<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary StructType
 * @subpackage Structs
 */
class Itinerary extends AbstractStructBase
{
    /**
     * The It_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $It_id;
    /**
     * The It_IdFleet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $It_IdFleet;
    /**
     * The It_Idgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $It_Idgroup;
    /**
     * The It_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $It_name;
    /**
     * The It_activo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $It_activo;
    /**
     * The It_auto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $It_auto;
    /**
     * The It_timeUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $It_timeUnit;
    /**
     * The It_timingP2P
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $It_timingP2P;
    /**
     * The ItPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItPoint
     */
    public $ItPoints;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setIt_id()
     * @uses Itinerary::setIt_IdFleet()
     * @uses Itinerary::setIt_Idgroup()
     * @uses Itinerary::setIt_name()
     * @uses Itinerary::setIt_activo()
     * @uses Itinerary::setIt_auto()
     * @uses Itinerary::setIt_timeUnit()
     * @uses Itinerary::setIt_timingP2P()
     * @uses Itinerary::setItPoints()
     * @param int $it_id
     * @param int $it_IdFleet
     * @param int $it_Idgroup
     * @param string $it_name
     * @param string $it_activo
     * @param string $it_auto
     * @param string $it_timeUnit
     * @param string $it_timingP2P
     * @param \ArrayType\ArrayOfItPoint $itPoints
     */
    public function __construct($it_id = null, $it_IdFleet = null, $it_Idgroup = null, $it_name = null, $it_activo = null, $it_auto = null, $it_timeUnit = null, $it_timingP2P = null, \ArrayType\ArrayOfItPoint $itPoints = null)
    {
        $this
            ->setIt_id($it_id)
            ->setIt_IdFleet($it_IdFleet)
            ->setIt_Idgroup($it_Idgroup)
            ->setIt_name($it_name)
            ->setIt_activo($it_activo)
            ->setIt_auto($it_auto)
            ->setIt_timeUnit($it_timeUnit)
            ->setIt_timingP2P($it_timingP2P)
            ->setItPoints($itPoints);
    }
    /**
     * Get It_id value
     * @return int
     */
    public function getIt_id()
    {
        return $this->It_id;
    }
    /**
     * Set It_id value
     * @param int $it_id
     * @return \StructType\Itinerary
     */
    public function setIt_id($it_id = null)
    {
        // validation for constraint: int
        if (!is_null($it_id) && !(is_int($it_id) || ctype_digit($it_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($it_id, true), gettype($it_id)), __LINE__);
        }
        $this->It_id = $it_id;
        return $this;
    }
    /**
     * Get It_IdFleet value
     * @return int
     */
    public function getIt_IdFleet()
    {
        return $this->It_IdFleet;
    }
    /**
     * Set It_IdFleet value
     * @param int $it_IdFleet
     * @return \StructType\Itinerary
     */
    public function setIt_IdFleet($it_IdFleet = null)
    {
        // validation for constraint: int
        if (!is_null($it_IdFleet) && !(is_int($it_IdFleet) || ctype_digit($it_IdFleet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($it_IdFleet, true), gettype($it_IdFleet)), __LINE__);
        }
        $this->It_IdFleet = $it_IdFleet;
        return $this;
    }
    /**
     * Get It_Idgroup value
     * @return int
     */
    public function getIt_Idgroup()
    {
        return $this->It_Idgroup;
    }
    /**
     * Set It_Idgroup value
     * @param int $it_Idgroup
     * @return \StructType\Itinerary
     */
    public function setIt_Idgroup($it_Idgroup = null)
    {
        // validation for constraint: int
        if (!is_null($it_Idgroup) && !(is_int($it_Idgroup) || ctype_digit($it_Idgroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($it_Idgroup, true), gettype($it_Idgroup)), __LINE__);
        }
        $this->It_Idgroup = $it_Idgroup;
        return $this;
    }
    /**
     * Get It_name value
     * @return string|null
     */
    public function getIt_name()
    {
        return $this->It_name;
    }
    /**
     * Set It_name value
     * @param string $it_name
     * @return \StructType\Itinerary
     */
    public function setIt_name($it_name = null)
    {
        // validation for constraint: string
        if (!is_null($it_name) && !is_string($it_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($it_name, true), gettype($it_name)), __LINE__);
        }
        $this->It_name = $it_name;
        return $this;
    }
    /**
     * Get It_activo value
     * @return string|null
     */
    public function getIt_activo()
    {
        return $this->It_activo;
    }
    /**
     * Set It_activo value
     * @param string $it_activo
     * @return \StructType\Itinerary
     */
    public function setIt_activo($it_activo = null)
    {
        // validation for constraint: string
        if (!is_null($it_activo) && !is_string($it_activo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($it_activo, true), gettype($it_activo)), __LINE__);
        }
        $this->It_activo = $it_activo;
        return $this;
    }
    /**
     * Get It_auto value
     * @return string|null
     */
    public function getIt_auto()
    {
        return $this->It_auto;
    }
    /**
     * Set It_auto value
     * @param string $it_auto
     * @return \StructType\Itinerary
     */
    public function setIt_auto($it_auto = null)
    {
        // validation for constraint: string
        if (!is_null($it_auto) && !is_string($it_auto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($it_auto, true), gettype($it_auto)), __LINE__);
        }
        $this->It_auto = $it_auto;
        return $this;
    }
    /**
     * Get It_timeUnit value
     * @return string|null
     */
    public function getIt_timeUnit()
    {
        return $this->It_timeUnit;
    }
    /**
     * Set It_timeUnit value
     * @param string $it_timeUnit
     * @return \StructType\Itinerary
     */
    public function setIt_timeUnit($it_timeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($it_timeUnit) && !is_string($it_timeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($it_timeUnit, true), gettype($it_timeUnit)), __LINE__);
        }
        $this->It_timeUnit = $it_timeUnit;
        return $this;
    }
    /**
     * Get It_timingP2P value
     * @return string|null
     */
    public function getIt_timingP2P()
    {
        return $this->It_timingP2P;
    }
    /**
     * Set It_timingP2P value
     * @param string $it_timingP2P
     * @return \StructType\Itinerary
     */
    public function setIt_timingP2P($it_timingP2P = null)
    {
        // validation for constraint: string
        if (!is_null($it_timingP2P) && !is_string($it_timingP2P)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($it_timingP2P, true), gettype($it_timingP2P)), __LINE__);
        }
        $this->It_timingP2P = $it_timingP2P;
        return $this;
    }
    /**
     * Get ItPoints value
     * @return \ArrayType\ArrayOfItPoint|null
     */
    public function getItPoints()
    {
        return $this->ItPoints;
    }
    /**
     * Set ItPoints value
     * @param \ArrayType\ArrayOfItPoint $itPoints
     * @return \StructType\Itinerary
     */
    public function setItPoints(\ArrayType\ArrayOfItPoint $itPoints = null)
    {
        $this->ItPoints = $itPoints;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
