<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FleetInfo StructType
 * @subpackage Structs
 */
class FleetInfo extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The FleetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FleetId;
    /**
     * The f_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $f_name;
    /**
     * The f_timezone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $f_timezone;
    /**
     * Constructor method for FleetInfo
     * @uses FleetInfo::setAccountId()
     * @uses FleetInfo::setFleetId()
     * @uses FleetInfo::setF_name()
     * @uses FleetInfo::setF_timezone()
     * @param int $accountId
     * @param int $fleetId
     * @param string $f_name
     * @param string $f_timezone
     */
    public function __construct($accountId = null, $fleetId = null, $f_name = null, $f_timezone = null)
    {
        $this
            ->setAccountId($accountId)
            ->setFleetId($fleetId)
            ->setF_name($f_name)
            ->setF_timezone($f_timezone);
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\FleetInfo
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get FleetId value
     * @return int
     */
    public function getFleetId()
    {
        return $this->FleetId;
    }
    /**
     * Set FleetId value
     * @param int $fleetId
     * @return \StructType\FleetInfo
     */
    public function setFleetId($fleetId = null)
    {
        // validation for constraint: int
        if (!is_null($fleetId) && !(is_int($fleetId) || ctype_digit($fleetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fleetId, true), gettype($fleetId)), __LINE__);
        }
        $this->FleetId = $fleetId;
        return $this;
    }
    /**
     * Get f_name value
     * @return string|null
     */
    public function getF_name()
    {
        return $this->f_name;
    }
    /**
     * Set f_name value
     * @param string $f_name
     * @return \StructType\FleetInfo
     */
    public function setF_name($f_name = null)
    {
        // validation for constraint: string
        if (!is_null($f_name) && !is_string($f_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($f_name, true), gettype($f_name)), __LINE__);
        }
        $this->f_name = $f_name;
        return $this;
    }
    /**
     * Get f_timezone value
     * @return string|null
     */
    public function getF_timezone()
    {
        return $this->f_timezone;
    }
    /**
     * Set f_timezone value
     * @param string $f_timezone
     * @return \StructType\FleetInfo
     */
    public function setF_timezone($f_timezone = null)
    {
        // validation for constraint: string
        if (!is_null($f_timezone) && !is_string($f_timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($f_timezone, true), gettype($f_timezone)), __LINE__);
        }
        $this->f_timezone = $f_timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FleetInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
