<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CANEventLocation StructType
 * @subpackage Structs
 */
class CANEventLocation extends AbstractStructBase
{
    /**
     * The regId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The eventID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $eventID;
    /**
     * The vIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vIndex;
    /**
     * The vValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $vValue;
    /**
     * The slope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $slope;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $speed;
    /**
     * The precision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $precision;
    /**
     * The altitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $altitude;
    /**
     * The heading
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $heading;
    /**
     * The age
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $age;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The gps_GMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gps_GMT;
    /**
     * The system_GMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_GMT;
    /**
     * Constructor method for CANEventLocation
     * @uses CANEventLocation::setRegId()
     * @uses CANEventLocation::setEventID()
     * @uses CANEventLocation::setVIndex()
     * @uses CANEventLocation::setVValue()
     * @uses CANEventLocation::setSlope()
     * @uses CANEventLocation::setLatitude()
     * @uses CANEventLocation::setLongitude()
     * @uses CANEventLocation::setSpeed()
     * @uses CANEventLocation::setPrecision()
     * @uses CANEventLocation::setAltitude()
     * @uses CANEventLocation::setHeading()
     * @uses CANEventLocation::setAge()
     * @uses CANEventLocation::setMId()
     * @uses CANEventLocation::setAddress()
     * @uses CANEventLocation::setGps_GMT()
     * @uses CANEventLocation::setSystem_GMT()
     * @param int $regId
     * @param int $eventID
     * @param int $vIndex
     * @param float $vValue
     * @param int $slope
     * @param float $latitude
     * @param float $longitude
     * @param int $speed
     * @param int $precision
     * @param int $altitude
     * @param int $heading
     * @param int $age
     * @param string $mId
     * @param string $address
     * @param string $gps_GMT
     * @param string $system_GMT
     */
    public function __construct($regId = null, $eventID = null, $vIndex = null, $vValue = null, $slope = null, $latitude = null, $longitude = null, $speed = null, $precision = null, $altitude = null, $heading = null, $age = null, $mId = null, $address = null, $gps_GMT = null, $system_GMT = null)
    {
        $this
            ->setRegId($regId)
            ->setEventID($eventID)
            ->setVIndex($vIndex)
            ->setVValue($vValue)
            ->setSlope($slope)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSpeed($speed)
            ->setPrecision($precision)
            ->setAltitude($altitude)
            ->setHeading($heading)
            ->setAge($age)
            ->setMId($mId)
            ->setAddress($address)
            ->setGps_GMT($gps_GMT)
            ->setSystem_GMT($system_GMT);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\CANEventLocation
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get eventID value
     * @return int
     */
    public function getEventID()
    {
        return $this->eventID;
    }
    /**
     * Set eventID value
     * @param int $eventID
     * @return \StructType\CANEventLocation
     */
    public function setEventID($eventID = null)
    {
        // validation for constraint: int
        if (!is_null($eventID) && !(is_int($eventID) || ctype_digit($eventID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventID, true), gettype($eventID)), __LINE__);
        }
        $this->eventID = $eventID;
        return $this;
    }
    /**
     * Get vIndex value
     * @return int
     */
    public function getVIndex()
    {
        return $this->vIndex;
    }
    /**
     * Set vIndex value
     * @param int $vIndex
     * @return \StructType\CANEventLocation
     */
    public function setVIndex($vIndex = null)
    {
        // validation for constraint: int
        if (!is_null($vIndex) && !(is_int($vIndex) || ctype_digit($vIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vIndex, true), gettype($vIndex)), __LINE__);
        }
        $this->vIndex = $vIndex;
        return $this;
    }
    /**
     * Get vValue value
     * @return float
     */
    public function getVValue()
    {
        return $this->vValue;
    }
    /**
     * Set vValue value
     * @param float $vValue
     * @return \StructType\CANEventLocation
     */
    public function setVValue($vValue = null)
    {
        // validation for constraint: float
        if (!is_null($vValue) && !(is_float($vValue) || is_numeric($vValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vValue, true), gettype($vValue)), __LINE__);
        }
        $this->vValue = $vValue;
        return $this;
    }
    /**
     * Get slope value
     * @return int
     */
    public function getSlope()
    {
        return $this->slope;
    }
    /**
     * Set slope value
     * @param int $slope
     * @return \StructType\CANEventLocation
     */
    public function setSlope($slope = null)
    {
        // validation for constraint: int
        if (!is_null($slope) && !(is_int($slope) || ctype_digit($slope))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($slope, true), gettype($slope)), __LINE__);
        }
        $this->slope = $slope;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\CANEventLocation
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\CANEventLocation
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param int $speed
     * @return \StructType\CANEventLocation
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->speed = $speed;
        return $this;
    }
    /**
     * Get precision value
     * @return int
     */
    public function getPrecision()
    {
        return $this->precision;
    }
    /**
     * Set precision value
     * @param int $precision
     * @return \StructType\CANEventLocation
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !(is_int($precision) || ctype_digit($precision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($precision, true), gettype($precision)), __LINE__);
        }
        $this->precision = $precision;
        return $this;
    }
    /**
     * Get altitude value
     * @return int
     */
    public function getAltitude()
    {
        return $this->altitude;
    }
    /**
     * Set altitude value
     * @param int $altitude
     * @return \StructType\CANEventLocation
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: int
        if (!is_null($altitude) && !(is_int($altitude) || ctype_digit($altitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        $this->altitude = $altitude;
        return $this;
    }
    /**
     * Get heading value
     * @return int
     */
    public function getHeading()
    {
        return $this->heading;
    }
    /**
     * Set heading value
     * @param int $heading
     * @return \StructType\CANEventLocation
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: int
        if (!is_null($heading) && !(is_int($heading) || ctype_digit($heading))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heading, true), gettype($heading)), __LINE__);
        }
        $this->heading = $heading;
        return $this;
    }
    /**
     * Get age value
     * @return int
     */
    public function getAge()
    {
        return $this->age;
    }
    /**
     * Set age value
     * @param int $age
     * @return \StructType\CANEventLocation
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->age = $age;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\CANEventLocation
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\CANEventLocation
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get gps_GMT value
     * @return string|null
     */
    public function getGps_GMT()
    {
        return $this->gps_GMT;
    }
    /**
     * Set gps_GMT value
     * @param string $gps_GMT
     * @return \StructType\CANEventLocation
     */
    public function setGps_GMT($gps_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($gps_GMT) && !is_string($gps_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_GMT, true), gettype($gps_GMT)), __LINE__);
        }
        $this->gps_GMT = $gps_GMT;
        return $this;
    }
    /**
     * Get system_GMT value
     * @return string|null
     */
    public function getSystem_GMT()
    {
        return $this->system_GMT;
    }
    /**
     * Set system_GMT value
     * @param string $system_GMT
     * @return \StructType\CANEventLocation
     */
    public function setSystem_GMT($system_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($system_GMT) && !is_string($system_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_GMT, true), gettype($system_GMT)), __LINE__);
        }
        $this->system_GMT = $system_GMT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CANEventLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
