<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETU ServiceType
 * @subpackage Services
 */
class SETU extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_UpdateDriver
     * Meta information extracted from the WSDL
     * - documentation: Se actualiza un conductor. Los campos dr_mId y dr_mIdValids serán ignorados y no se guardarán.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_UpdateDriver $parameters
     * @return \StructType\SET_UpdateDriverResponse|bool
     */
    public function SET_UpdateDriver(\StructType\SET_UpdateDriver $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_UpdateDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_UpdateDriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
