<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETC ServiceType
 * @subpackage Services
 */
class SETC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_CmdCancel
     * Meta information extracted from the WSDL
     * - documentation: Cancela el procesamiento de un comando.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_CmdCancel $parameters
     * @return \StructType\SET_CmdCancelResponse|bool
     */
    public function SET_CmdCancel(\StructType\SET_CmdCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_CmdCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_CmdCancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
