<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETT ServiceType
 * @subpackage Services
 */
class GETT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_TrackerOdometer
     * Meta information extracted from the WSDL
     * - documentation: Retorna el valor y última fecha de actualización del odómetro de un Móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerOdometer $parameters
     * @return \StructType\GET_TrackerOdometerResponse|bool
     */
    public function GET_TrackerOdometer(\StructType\GET_TrackerOdometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerOdometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_TrackerOdometerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
