<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETM ServiceType
 * @subpackage Services
 */
class GETM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_MobileList
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el listado de los móviles de una flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileList $parameters
     * @return \StructType\GET_MobileListResponse|bool
     */
    public function GET_MobileList(\StructType\GET_MobileList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileGroups
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el listado de los grupos de móviles de una flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileGroups $parameters
     * @return \StructType\GET_MobileGroupsResponse|bool
     */
    public function GET_MobileGroups(\StructType\GET_MobileGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileInfo
     * Meta information extracted from the WSDL
     * - documentation: Devuelve la información de un móvil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileInfo $parameters
     * @return \StructType\GET_MobileInfoResponse|bool
     */
    public function GET_MobileInfo(\StructType\GET_MobileInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileStatusHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de estados del móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileStatusHistory $parameters
     * @return \StructType\GET_MobileStatusHistoryResponse|bool
     */
    public function GET_MobileStatusHistory(\StructType\GET_MobileStatusHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileStatusHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_MobileOperationInfo
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el listado de los móviles asociados a la flota o grupo del usuario. lastGPSDate e itInittime se dan en el formato yyyy-mm-dd hh:mm:ss.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_MobileOperationInfo $parameters
     * @return \StructType\GET_MobileOperationInfoResponse|bool
     */
    public function GET_MobileOperationInfo(\StructType\GET_MobileOperationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_MobileOperationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_MobileGroupsResponse|\StructType\GET_MobileInfoResponse|\StructType\GET_MobileListResponse|\StructType\GET_MobileOperationInfoResponse|\StructType\GET_MobileStatusHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
