<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETG ServiceType
 * @subpackage Services
 */
class GETG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_GeolocatedPassengerHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de contadores geolocalizados de pasajeros de un vehículo. datetime_init y datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss y en UTC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_GeolocatedPassengerHistory $parameters
     * @return \StructType\GET_GeolocatedPassengerHistoryResponse|bool
     */
    public function GET_GeolocatedPassengerHistory(\StructType\GET_GeolocatedPassengerHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_GeolocatedPassengerHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_GeolocatedPassengerHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
