<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETCANE ServiceType
 * @subpackage Services
 */
class GETCANE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_CANEventsHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de eventos del CAN BUS. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CANEventsHistory $parameters
     * @return \StructType\GET_CANEventsHistoryResponse|bool
     */
    public function GET_CANEventsHistory(\StructType\GET_CANEventsHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CANEventsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_CANEventsHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
