<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETC ServiceType
 * @subpackage Services
 */
class GETC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_CmdStatus
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el estado del procesamiento de un comando o mensaje.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CmdStatus $parameters
     * @return \StructType\GET_CmdStatusResponse|bool
     */
    public function GET_CmdStatus(\StructType\GET_CmdStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CmdStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_CounterHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de contadores del móvil (distancia y tiempo de uso). UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CounterHistory $parameters
     * @return \StructType\GET_CounterHistoryResponse|bool
     */
    public function GET_CounterHistory(\StructType\GET_CounterHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CounterHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_CommandList
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el listado de los comandos disponibles para un móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_CommandList $parameters
     * @return \StructType\GET_CommandListResponse|bool
     */
    public function GET_CommandList(\StructType\GET_CommandList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_CommandList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_CmdStatusResponse|\StructType\GET_CommandListResponse|\StructType\GET_CounterHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
