<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFleetInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfFleetInfo extends AbstractStructArrayBase
{
    /**
     * The FleetInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FleetInfo[]
     */
    public $FleetInfo;
    /**
     * Constructor method for ArrayOfFleetInfo
     * @uses ArrayOfFleetInfo::setFleetInfo()
     * @param \StructType\FleetInfo[] $fleetInfo
     */
    public function __construct(array $fleetInfo = array())
    {
        $this
            ->setFleetInfo($fleetInfo);
    }
    /**
     * Get FleetInfo value
     * @return \StructType\FleetInfo[]|null
     */
    public function getFleetInfo()
    {
        return $this->FleetInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFleetInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFleetInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFleetInfoForArrayConstraintsFromSetFleetInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFleetInfoFleetInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfFleetInfoFleetInfoItem instanceof \StructType\FleetInfo) {
                $invalidValues[] = is_object($arrayOfFleetInfoFleetInfoItem) ? get_class($arrayOfFleetInfoFleetInfoItem) : sprintf('%s(%s)', gettype($arrayOfFleetInfoFleetInfoItem), var_export($arrayOfFleetInfoFleetInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FleetInfo property can only contain items of type \StructType\FleetInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FleetInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FleetInfo[] $fleetInfo
     * @return \ArrayType\ArrayOfFleetInfo
     */
    public function setFleetInfo(array $fleetInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($fleetInfoArrayErrorMessage = self::validateFleetInfoForArrayConstraintsFromSetFleetInfo($fleetInfo))) {
            throw new \InvalidArgumentException($fleetInfoArrayErrorMessage, __LINE__);
        }
        $this->FleetInfo = $fleetInfo;
        return $this;
    }
    /**
     * Add item to FleetInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FleetInfo $item
     * @return \ArrayType\ArrayOfFleetInfo
     */
    public function addToFleetInfo(\StructType\FleetInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FleetInfo) {
            throw new \InvalidArgumentException(sprintf('The FleetInfo property can only contain items of type \StructType\FleetInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FleetInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FleetInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FleetInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FleetInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FleetInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FleetInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FleetInfo
     */
    public function getAttributeName()
    {
        return 'FleetInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFleetInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
