<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFilteredGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfFilteredGroup extends AbstractStructArrayBase
{
    /**
     * The FilteredGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FilteredGroup[]
     */
    public $FilteredGroup;
    /**
     * Constructor method for ArrayOfFilteredGroup
     * @uses ArrayOfFilteredGroup::setFilteredGroup()
     * @param \StructType\FilteredGroup[] $filteredGroup
     */
    public function __construct(array $filteredGroup = array())
    {
        $this
            ->setFilteredGroup($filteredGroup);
    }
    /**
     * Get FilteredGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FilteredGroup[]|null
     */
    public function getFilteredGroup()
    {
        return isset($this->FilteredGroup) ? $this->FilteredGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFilteredGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilteredGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilteredGroupForArrayConstraintsFromSetFilteredGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFilteredGroupFilteredGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfFilteredGroupFilteredGroupItem instanceof \StructType\FilteredGroup) {
                $invalidValues[] = is_object($arrayOfFilteredGroupFilteredGroupItem) ? get_class($arrayOfFilteredGroupFilteredGroupItem) : sprintf('%s(%s)', gettype($arrayOfFilteredGroupFilteredGroupItem), var_export($arrayOfFilteredGroupFilteredGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FilteredGroup property can only contain items of type \StructType\FilteredGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FilteredGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FilteredGroup[] $filteredGroup
     * @return \ArrayType\ArrayOfFilteredGroup
     */
    public function setFilteredGroup(array $filteredGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($filteredGroupArrayErrorMessage = self::validateFilteredGroupForArrayConstraintsFromSetFilteredGroup($filteredGroup))) {
            throw new \InvalidArgumentException($filteredGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($filteredGroup) || (is_array($filteredGroup) && empty($filteredGroup))) {
            unset($this->FilteredGroup);
        } else {
            $this->FilteredGroup = $filteredGroup;
        }
        return $this;
    }
    /**
     * Add item to FilteredGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\FilteredGroup $item
     * @return \ArrayType\ArrayOfFilteredGroup
     */
    public function addToFilteredGroup(\StructType\FilteredGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilteredGroup) {
            throw new \InvalidArgumentException(sprintf('The FilteredGroup property can only contain items of type \StructType\FilteredGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FilteredGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FilteredGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FilteredGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FilteredGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FilteredGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FilteredGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FilteredGroup
     */
    public function getAttributeName()
    {
        return 'FilteredGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFilteredGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
