<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventLocation ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventLocation extends AbstractStructArrayBase
{
    /**
     * The EventLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventLocation[]
     */
    public $EventLocation;
    /**
     * Constructor method for ArrayOfEventLocation
     * @uses ArrayOfEventLocation::setEventLocation()
     * @param \StructType\EventLocation[] $eventLocation
     */
    public function __construct(array $eventLocation = array())
    {
        $this
            ->setEventLocation($eventLocation);
    }
    /**
     * Get EventLocation value
     * @return \StructType\EventLocation[]|null
     */
    public function getEventLocation()
    {
        return $this->EventLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setEventLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventLocationForArrayConstraintsFromSetEventLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventLocationEventLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventLocationEventLocationItem instanceof \StructType\EventLocation) {
                $invalidValues[] = is_object($arrayOfEventLocationEventLocationItem) ? get_class($arrayOfEventLocationEventLocationItem) : sprintf('%s(%s)', gettype($arrayOfEventLocationEventLocationItem), var_export($arrayOfEventLocationEventLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventLocation property can only contain items of type \StructType\EventLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\EventLocation[] $eventLocation
     * @return \ArrayType\ArrayOfEventLocation
     */
    public function setEventLocation(array $eventLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($eventLocationArrayErrorMessage = self::validateEventLocationForArrayConstraintsFromSetEventLocation($eventLocation))) {
            throw new \InvalidArgumentException($eventLocationArrayErrorMessage, __LINE__);
        }
        $this->EventLocation = $eventLocation;
        return $this;
    }
    /**
     * Add item to EventLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\EventLocation $item
     * @return \ArrayType\ArrayOfEventLocation
     */
    public function addToEventLocation(\StructType\EventLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventLocation) {
            throw new \InvalidArgumentException(sprintf('The EventLocation property can only contain items of type \StructType\EventLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventLocation
     */
    public function getAttributeName()
    {
        return 'EventLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEventLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
