<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDoor ArrayType
 * @subpackage Arrays
 */
class ArrayOfDoor extends AbstractStructArrayBase
{
    /**
     * The Door
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Door[]
     */
    public $Door;
    /**
     * Constructor method for ArrayOfDoor
     * @uses ArrayOfDoor::setDoor()
     * @param \StructType\Door[] $door
     */
    public function __construct(array $door = array())
    {
        $this
            ->setDoor($door);
    }
    /**
     * Get Door value
     * @return \StructType\Door[]|null
     */
    public function getDoor()
    {
        return $this->Door;
    }
    /**
     * This method is responsible for validating the values passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorForArrayConstraintsFromSetDoor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDoorDoorItem) {
            // validation for constraint: itemType
            if (!$arrayOfDoorDoorItem instanceof \StructType\Door) {
                $invalidValues[] = is_object($arrayOfDoorDoorItem) ? get_class($arrayOfDoorDoorItem) : sprintf('%s(%s)', gettype($arrayOfDoorDoorItem), var_export($arrayOfDoorDoorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door[] $door
     * @return \ArrayType\ArrayOfDoor
     */
    public function setDoor(array $door = array())
    {
        // validation for constraint: array
        if ('' !== ($doorArrayErrorMessage = self::validateDoorForArrayConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorArrayErrorMessage, __LINE__);
        }
        $this->Door = $door;
        return $this;
    }
    /**
     * Add item to Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door $item
     * @return \ArrayType\ArrayOfDoor
     */
    public function addToDoor(\StructType\Door $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Door) {
            throw new \InvalidArgumentException(sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Door[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Door|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Door|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Door|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Door|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Door|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Door
     */
    public function getAttributeName()
    {
        return 'Door';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDoor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
