<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilteredGroup StructType
 * @subpackage Structs
 */
class FilteredGroup extends AbstractStructBase
{
    /**
     * The gId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gId;
    /**
     * The gName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gName;
    /**
     * The mIdList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $mIdList;
    /**
     * Constructor method for FilteredGroup
     * @uses FilteredGroup::setGId()
     * @uses FilteredGroup::setGName()
     * @uses FilteredGroup::setMIdList()
     * @param int $gId
     * @param string $gName
     * @param \ArrayType\ArrayOfString $mIdList
     */
    public function __construct($gId = null, $gName = null, \ArrayType\ArrayOfString $mIdList = null)
    {
        $this
            ->setGId($gId)
            ->setGName($gName)
            ->setMIdList($mIdList);
    }
    /**
     * Get gId value
     * @return int
     */
    public function getGId()
    {
        return $this->gId;
    }
    /**
     * Set gId value
     * @param int $gId
     * @return \StructType\FilteredGroup
     */
    public function setGId($gId = null)
    {
        // validation for constraint: int
        if (!is_null($gId) && !(is_int($gId) || ctype_digit($gId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gId, true), gettype($gId)), __LINE__);
        }
        $this->gId = $gId;
        return $this;
    }
    /**
     * Get gName value
     * @return string|null
     */
    public function getGName()
    {
        return $this->gName;
    }
    /**
     * Set gName value
     * @param string $gName
     * @return \StructType\FilteredGroup
     */
    public function setGName($gName = null)
    {
        // validation for constraint: string
        if (!is_null($gName) && !is_string($gName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gName, true), gettype($gName)), __LINE__);
        }
        $this->gName = $gName;
        return $this;
    }
    /**
     * Get mIdList value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getMIdList()
    {
        return $this->mIdList;
    }
    /**
     * Set mIdList value
     * @param \ArrayType\ArrayOfString $mIdList
     * @return \StructType\FilteredGroup
     */
    public function setMIdList(\ArrayType\ArrayOfString $mIdList = null)
    {
        $this->mIdList = $mIdList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilteredGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
