<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETE ServiceType
 * @subpackage Services
 */
class GETE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_EventsHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de eventos de un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_EventsHistory $parameters
     * @return \StructType\GET_EventsHistoryResponse|bool
     */
    public function GET_EventsHistory(\StructType\GET_EventsHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_EventsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_EventsHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
