<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileDistance ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileDistance extends AbstractStructArrayBase
{
    /**
     * The MobileDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MobileDistance[]
     */
    public $MobileDistance;
    /**
     * Constructor method for ArrayOfMobileDistance
     * @uses ArrayOfMobileDistance::setMobileDistance()
     * @param \StructType\MobileDistance[] $mobileDistance
     */
    public function __construct(array $mobileDistance = array())
    {
        $this
            ->setMobileDistance($mobileDistance);
    }
    /**
     * Get MobileDistance value
     * @return \StructType\MobileDistance[]|null
     */
    public function getMobileDistance()
    {
        return $this->MobileDistance;
    }
    /**
     * This method is responsible for validating the values passed to the setMobileDistance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMobileDistance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMobileDistanceForArrayConstraintsFromSetMobileDistance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMobileDistanceMobileDistanceItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileDistanceMobileDistanceItem instanceof \StructType\MobileDistance) {
                $invalidValues[] = is_object($arrayOfMobileDistanceMobileDistanceItem) ? get_class($arrayOfMobileDistanceMobileDistanceItem) : sprintf('%s(%s)', gettype($arrayOfMobileDistanceMobileDistanceItem), var_export($arrayOfMobileDistanceMobileDistanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MobileDistance property can only contain items of type \StructType\MobileDistance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MobileDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileDistance[] $mobileDistance
     * @return \ArrayType\ArrayOfMobileDistance
     */
    public function setMobileDistance(array $mobileDistance = array())
    {
        // validation for constraint: array
        if ('' !== ($mobileDistanceArrayErrorMessage = self::validateMobileDistanceForArrayConstraintsFromSetMobileDistance($mobileDistance))) {
            throw new \InvalidArgumentException($mobileDistanceArrayErrorMessage, __LINE__);
        }
        $this->MobileDistance = $mobileDistance;
        return $this;
    }
    /**
     * Add item to MobileDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileDistance $item
     * @return \ArrayType\ArrayOfMobileDistance
     */
    public function addToMobileDistance(\StructType\MobileDistance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileDistance) {
            throw new \InvalidArgumentException(sprintf('The MobileDistance property can only contain items of type \StructType\MobileDistance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MobileDistance[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileDistance|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileDistance|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileDistance|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileDistance|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileDistance|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileDistance
     */
    public function getAttributeName()
    {
        return 'MobileDistance';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMobileDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
