<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileOperationInfo StructType
 * @subpackage Structs
 */
class MobileOperationInfo extends AbstractStructBase
{
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The itId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $itId;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The plate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $plate;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The driverDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverDocument;
    /**
     * The driverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverName;
    /**
     * The commToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commToday;
    /**
     * The lastGPSDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastGPSDate;
    /**
     * The itDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itDescription;
    /**
     * The itInittime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itInittime;
    /**
     * Constructor method for MobileOperationInfo
     * @uses MobileOperationInfo::setLatitude()
     * @uses MobileOperationInfo::setLongitude()
     * @uses MobileOperationInfo::setItId()
     * @uses MobileOperationInfo::setMId()
     * @uses MobileOperationInfo::setPlate()
     * @uses MobileOperationInfo::setDescription()
     * @uses MobileOperationInfo::setDriverDocument()
     * @uses MobileOperationInfo::setDriverName()
     * @uses MobileOperationInfo::setCommToday()
     * @uses MobileOperationInfo::setLastGPSDate()
     * @uses MobileOperationInfo::setItDescription()
     * @uses MobileOperationInfo::setItInittime()
     * @param float $latitude
     * @param float $longitude
     * @param int $itId
     * @param string $mId
     * @param string $plate
     * @param string $description
     * @param string $driverDocument
     * @param string $driverName
     * @param string $commToday
     * @param string $lastGPSDate
     * @param string $itDescription
     * @param string $itInittime
     */
    public function __construct($latitude = null, $longitude = null, $itId = null, $mId = null, $plate = null, $description = null, $driverDocument = null, $driverName = null, $commToday = null, $lastGPSDate = null, $itDescription = null, $itInittime = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setItId($itId)
            ->setMId($mId)
            ->setPlate($plate)
            ->setDescription($description)
            ->setDriverDocument($driverDocument)
            ->setDriverName($driverName)
            ->setCommToday($commToday)
            ->setLastGPSDate($lastGPSDate)
            ->setItDescription($itDescription)
            ->setItInittime($itInittime);
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\MobileOperationInfo
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\MobileOperationInfo
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get itId value
     * @return int
     */
    public function getItId()
    {
        return $this->itId;
    }
    /**
     * Set itId value
     * @param int $itId
     * @return \StructType\MobileOperationInfo
     */
    public function setItId($itId = null)
    {
        // validation for constraint: int
        if (!is_null($itId) && !(is_int($itId) || ctype_digit($itId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itId, true), gettype($itId)), __LINE__);
        }
        $this->itId = $itId;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\MobileOperationInfo
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get plate value
     * @return string|null
     */
    public function getPlate()
    {
        return $this->plate;
    }
    /**
     * Set plate value
     * @param string $plate
     * @return \StructType\MobileOperationInfo
     */
    public function setPlate($plate = null)
    {
        // validation for constraint: string
        if (!is_null($plate) && !is_string($plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plate, true), gettype($plate)), __LINE__);
        }
        $this->plate = $plate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MobileOperationInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get driverDocument value
     * @return string|null
     */
    public function getDriverDocument()
    {
        return $this->driverDocument;
    }
    /**
     * Set driverDocument value
     * @param string $driverDocument
     * @return \StructType\MobileOperationInfo
     */
    public function setDriverDocument($driverDocument = null)
    {
        // validation for constraint: string
        if (!is_null($driverDocument) && !is_string($driverDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDocument, true), gettype($driverDocument)), __LINE__);
        }
        $this->driverDocument = $driverDocument;
        return $this;
    }
    /**
     * Get driverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->driverName;
    }
    /**
     * Set driverName value
     * @param string $driverName
     * @return \StructType\MobileOperationInfo
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->driverName = $driverName;
        return $this;
    }
    /**
     * Get commToday value
     * @return string|null
     */
    public function getCommToday()
    {
        return $this->commToday;
    }
    /**
     * Set commToday value
     * @param string $commToday
     * @return \StructType\MobileOperationInfo
     */
    public function setCommToday($commToday = null)
    {
        // validation for constraint: string
        if (!is_null($commToday) && !is_string($commToday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commToday, true), gettype($commToday)), __LINE__);
        }
        $this->commToday = $commToday;
        return $this;
    }
    /**
     * Get lastGPSDate value
     * @return string|null
     */
    public function getLastGPSDate()
    {
        return $this->lastGPSDate;
    }
    /**
     * Set lastGPSDate value
     * @param string $lastGPSDate
     * @return \StructType\MobileOperationInfo
     */
    public function setLastGPSDate($lastGPSDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastGPSDate) && !is_string($lastGPSDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastGPSDate, true), gettype($lastGPSDate)), __LINE__);
        }
        $this->lastGPSDate = $lastGPSDate;
        return $this;
    }
    /**
     * Get itDescription value
     * @return string|null
     */
    public function getItDescription()
    {
        return $this->itDescription;
    }
    /**
     * Set itDescription value
     * @param string $itDescription
     * @return \StructType\MobileOperationInfo
     */
    public function setItDescription($itDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itDescription) && !is_string($itDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itDescription, true), gettype($itDescription)), __LINE__);
        }
        $this->itDescription = $itDescription;
        return $this;
    }
    /**
     * Get itInittime value
     * @return string|null
     */
    public function getItInittime()
    {
        return $this->itInittime;
    }
    /**
     * Set itInittime value
     * @param string $itInittime
     * @return \StructType\MobileOperationInfo
     */
    public function setItInittime($itInittime = null)
    {
        // validation for constraint: string
        if (!is_null($itInittime) && !is_string($itInittime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itInittime, true), gettype($itInittime)), __LINE__);
        }
        $this->itInittime = $itInittime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileOperationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
