<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileGeofence StructType
 * @subpackage Structs
 */
class MobileGeofence extends AbstractStructBase
{
    /**
     * The g_index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $g_index;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The g_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $g_name;
    /**
     * The g_active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $g_active;
    /**
     * Constructor method for MobileGeofence
     * @uses MobileGeofence::setG_index()
     * @uses MobileGeofence::setMId()
     * @uses MobileGeofence::setG_name()
     * @uses MobileGeofence::setG_active()
     * @param int $g_index
     * @param string $mId
     * @param string $g_name
     * @param string $g_active
     */
    public function __construct($g_index = null, $mId = null, $g_name = null, $g_active = null)
    {
        $this
            ->setG_index($g_index)
            ->setMId($mId)
            ->setG_name($g_name)
            ->setG_active($g_active);
    }
    /**
     * Get g_index value
     * @return int
     */
    public function getG_index()
    {
        return $this->g_index;
    }
    /**
     * Set g_index value
     * @param int $g_index
     * @return \StructType\MobileGeofence
     */
    public function setG_index($g_index = null)
    {
        // validation for constraint: int
        if (!is_null($g_index) && !(is_int($g_index) || ctype_digit($g_index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g_index, true), gettype($g_index)), __LINE__);
        }
        $this->g_index = $g_index;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\MobileGeofence
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get g_name value
     * @return string|null
     */
    public function getG_name()
    {
        return $this->g_name;
    }
    /**
     * Set g_name value
     * @param string $g_name
     * @return \StructType\MobileGeofence
     */
    public function setG_name($g_name = null)
    {
        // validation for constraint: string
        if (!is_null($g_name) && !is_string($g_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($g_name, true), gettype($g_name)), __LINE__);
        }
        $this->g_name = $g_name;
        return $this;
    }
    /**
     * Get g_active value
     * @return string|null
     */
    public function getG_active()
    {
        return $this->g_active;
    }
    /**
     * Set g_active value
     * @param string $g_active
     * @return \StructType\MobileGeofence
     */
    public function setG_active($g_active = null)
    {
        // validation for constraint: string
        if (!is_null($g_active) && !is_string($g_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($g_active, true), gettype($g_active)), __LINE__);
        }
        $this->g_active = $g_active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
