<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInfo StructType
 * @subpackage Structs
 */
class AccountInfo extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The a_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $a_name;
    /**
     * The a_country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $a_country;
    /**
     * The a_timezone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $a_timezone;
    /**
     * Constructor method for AccountInfo
     * @uses AccountInfo::setAccountId()
     * @uses AccountInfo::setA_name()
     * @uses AccountInfo::setA_country()
     * @uses AccountInfo::setA_timezone()
     * @param int $accountId
     * @param string $a_name
     * @param string $a_country
     * @param string $a_timezone
     */
    public function __construct($accountId = null, $a_name = null, $a_country = null, $a_timezone = null)
    {
        $this
            ->setAccountId($accountId)
            ->setA_name($a_name)
            ->setA_country($a_country)
            ->setA_timezone($a_timezone);
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\AccountInfo
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get a_name value
     * @return string|null
     */
    public function getA_name()
    {
        return $this->a_name;
    }
    /**
     * Set a_name value
     * @param string $a_name
     * @return \StructType\AccountInfo
     */
    public function setA_name($a_name = null)
    {
        // validation for constraint: string
        if (!is_null($a_name) && !is_string($a_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($a_name, true), gettype($a_name)), __LINE__);
        }
        $this->a_name = $a_name;
        return $this;
    }
    /**
     * Get a_country value
     * @return string|null
     */
    public function getA_country()
    {
        return $this->a_country;
    }
    /**
     * Set a_country value
     * @param string $a_country
     * @return \StructType\AccountInfo
     */
    public function setA_country($a_country = null)
    {
        // validation for constraint: string
        if (!is_null($a_country) && !is_string($a_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($a_country, true), gettype($a_country)), __LINE__);
        }
        $this->a_country = $a_country;
        return $this;
    }
    /**
     * Get a_timezone value
     * @return string|null
     */
    public function getA_timezone()
    {
        return $this->a_timezone;
    }
    /**
     * Set a_timezone value
     * @param string $a_timezone
     * @return \StructType\AccountInfo
     */
    public function setA_timezone($a_timezone = null)
    {
        // validation for constraint: string
        if (!is_null($a_timezone) && !is_string($a_timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($a_timezone, true), gettype($a_timezone)), __LINE__);
        }
        $this->a_timezone = $a_timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
