<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETR ServiceType
 * @subpackage Services
 */
class GETR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_ReferencePoints
     * Meta informations extracted from the WSDL
     * - documentation: Para ver todos los puntos de referencia asociados a una flota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ReferencePoints $parameters
     * @return \StructType\GET_ReferencePointsResponse|bool
     */
    public function GET_ReferencePoints(\StructType\GET_ReferencePoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ReferencePoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_ReferencePointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
