<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETP ServiceType
 * @subpackage Services
 */
class GETP extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_PendingAlerts
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve las alertas no procesadas de un móvil, de una flota o de una cuenta.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_PendingAlerts $parameters
     * @return \StructType\GET_PendingAlertsResponse|bool
     */
    public function GET_PendingAlerts(\StructType\GET_PendingAlerts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_PendingAlerts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_PassengersCounter
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de contadores de pasajeros de un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_PassengersCounter $parameters
     * @return \StructType\GET_PassengersCounterResponse|bool
     */
    public function GET_PassengersCounter(\StructType\GET_PassengersCounter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_PassengersCounter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_PassengersCounterResponse|\StructType\GET_PendingAlertsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
