<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETN ServiceType
 * @subpackage Services
 */
class GETN extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_NearestEventWhen
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el evento más cercano a la fecha y hora especificada. UTC_datetime se da en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_NearestEventWhen $parameters
     * @return \StructType\GET_NearestEventWhenResponse|bool
     */
    public function GET_NearestEventWhen(\StructType\GET_NearestEventWhen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_NearestEventWhen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_NearestMobiles
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve los moviles disponibles mas cercanos a las coordenadas dadas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_NearestMobiles $parameters
     * @return \StructType\GET_NearestMobilesResponse|bool
     */
    public function GET_NearestMobiles(\StructType\GET_NearestMobiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_NearestMobiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_NextItPointArrival
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve información del siguiente punto en el itinerario en curso.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_NextItPointArrival $parameters
     * @return \StructType\GET_NextItPointArrivalResponse|bool
     */
    public function GET_NextItPointArrival(\StructType\GET_NextItPointArrival $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_NextItPointArrival($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_NearestEventWhenResponse|\StructType\GET_NearestMobilesResponse|\StructType\GET_NextItPointArrivalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
