<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZoneDef StructType
 * @subpackage Structs
 */
class ZoneDef extends AbstractStructBase
{
    /**
     * The zoneId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $zoneId;
    /**
     * The zFleetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $zFleetId;
    /**
     * The zName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zName;
    /**
     * The zPolygon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPoint_2D
     */
    public $zPolygon;
    /**
     * Constructor method for ZoneDef
     * @uses ZoneDef::setZoneId()
     * @uses ZoneDef::setZFleetId()
     * @uses ZoneDef::setZName()
     * @uses ZoneDef::setZPolygon()
     * @param int $zoneId
     * @param int $zFleetId
     * @param string $zName
     * @param \ArrayType\ArrayOfPoint_2D $zPolygon
     */
    public function __construct($zoneId = null, $zFleetId = null, $zName = null, \ArrayType\ArrayOfPoint_2D $zPolygon = null)
    {
        $this
            ->setZoneId($zoneId)
            ->setZFleetId($zFleetId)
            ->setZName($zName)
            ->setZPolygon($zPolygon);
    }
    /**
     * Get zoneId value
     * @return int
     */
    public function getZoneId()
    {
        return $this->zoneId;
    }
    /**
     * Set zoneId value
     * @param int $zoneId
     * @return \StructType\ZoneDef
     */
    public function setZoneId($zoneId = null)
    {
        // validation for constraint: int
        if (!is_null($zoneId) && !(is_int($zoneId) || ctype_digit($zoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneId, true), gettype($zoneId)), __LINE__);
        }
        $this->zoneId = $zoneId;
        return $this;
    }
    /**
     * Get zFleetId value
     * @return int
     */
    public function getZFleetId()
    {
        return $this->zFleetId;
    }
    /**
     * Set zFleetId value
     * @param int $zFleetId
     * @return \StructType\ZoneDef
     */
    public function setZFleetId($zFleetId = null)
    {
        // validation for constraint: int
        if (!is_null($zFleetId) && !(is_int($zFleetId) || ctype_digit($zFleetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zFleetId, true), gettype($zFleetId)), __LINE__);
        }
        $this->zFleetId = $zFleetId;
        return $this;
    }
    /**
     * Get zName value
     * @return string|null
     */
    public function getZName()
    {
        return $this->zName;
    }
    /**
     * Set zName value
     * @param string $zName
     * @return \StructType\ZoneDef
     */
    public function setZName($zName = null)
    {
        // validation for constraint: string
        if (!is_null($zName) && !is_string($zName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zName, true), gettype($zName)), __LINE__);
        }
        $this->zName = $zName;
        return $this;
    }
    /**
     * Get zPolygon value
     * @return \ArrayType\ArrayOfPoint_2D|null
     */
    public function getZPolygon()
    {
        return $this->zPolygon;
    }
    /**
     * Set zPolygon value
     * @param \ArrayType\ArrayOfPoint_2D $zPolygon
     * @return \StructType\ZoneDef
     */
    public function setZPolygon(\ArrayType\ArrayOfPoint_2D $zPolygon = null)
    {
        $this->zPolygon = $zPolygon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZoneDef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
