<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CANVariables StructType
 * @subpackage Structs
 */
class CANVariables extends AbstractStructBase
{
    /**
     * The vIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vIndex;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The vDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vDescription;
    /**
     * Constructor method for CANVariables
     * @uses CANVariables::setVIndex()
     * @uses CANVariables::setMId()
     * @uses CANVariables::setVDescription()
     * @param int $vIndex
     * @param string $mId
     * @param string $vDescription
     */
    public function __construct($vIndex = null, $mId = null, $vDescription = null)
    {
        $this
            ->setVIndex($vIndex)
            ->setMId($mId)
            ->setVDescription($vDescription);
    }
    /**
     * Get vIndex value
     * @return int
     */
    public function getVIndex()
    {
        return $this->vIndex;
    }
    /**
     * Set vIndex value
     * @param int $vIndex
     * @return \StructType\CANVariables
     */
    public function setVIndex($vIndex = null)
    {
        // validation for constraint: int
        if (!is_null($vIndex) && !(is_int($vIndex) || ctype_digit($vIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vIndex, true), gettype($vIndex)), __LINE__);
        }
        $this->vIndex = $vIndex;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\CANVariables
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get vDescription value
     * @return string|null
     */
    public function getVDescription()
    {
        return $this->vDescription;
    }
    /**
     * Set vDescription value
     * @param string $vDescription
     * @return \StructType\CANVariables
     */
    public function setVDescription($vDescription = null)
    {
        // validation for constraint: string
        if (!is_null($vDescription) && !is_string($vDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vDescription, true), gettype($vDescription)), __LINE__);
        }
        $this->vDescription = $vDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CANVariables
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
