<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETS ServiceType
 * @subpackage Services
 */
class SETS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_ServiceAssign
     * Meta informations extracted from the WSDL
     * - documentation: Asigna un servicio a un móvil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_ServiceAssign $parameters
     * @return \StructType\SET_ServiceAssignResponse|bool
     */
    public function SET_ServiceAssign(\StructType\SET_ServiceAssign $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SET_ServiceAssign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_ServiceAssignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
