<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriver ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriver extends AbstractStructArrayBase
{
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Driver[]
     */
    public $Driver;
    /**
     * Constructor method for ArrayOfDriver
     * @uses ArrayOfDriver::setDriver()
     * @param \StructType\Driver[] $driver
     */
    public function __construct(array $driver = array())
    {
        $this
            ->setDriver($driver);
    }
    /**
     * Get Driver value
     * @return \StructType\Driver[]|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * This method is responsible for validating the values passed to the setDriver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverForArrayConstraintsFromSetDriver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDriverDriverItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverDriverItem instanceof \StructType\Driver) {
                $invalidValues[] = is_object($arrayOfDriverDriverItem) ? get_class($arrayOfDriverDriverItem) : sprintf('%s(%s)', gettype($arrayOfDriverDriverItem), var_export($arrayOfDriverDriverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Driver property can only contain items of type \StructType\Driver, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Driver value
     * @throws \InvalidArgumentException
     * @param \StructType\Driver[] $driver
     * @return \ArrayType\ArrayOfDriver
     */
    public function setDriver(array $driver = array())
    {
        // validation for constraint: array
        if ('' !== ($driverArrayErrorMessage = self::validateDriverForArrayConstraintsFromSetDriver($driver))) {
            throw new \InvalidArgumentException($driverArrayErrorMessage, __LINE__);
        }
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Add item to Driver value
     * @throws \InvalidArgumentException
     * @param \StructType\Driver $item
     * @return \ArrayType\ArrayOfDriver
     */
    public function addToDriver(\StructType\Driver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Driver) {
            throw new \InvalidArgumentException(sprintf('The Driver property can only contain items of type \StructType\Driver, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Driver[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Driver|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Driver|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Driver|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Driver|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Driver|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Driver
     */
    public function getAttributeName()
    {
        return 'Driver';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
