<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SATStatus StructType
 * @subpackage Structs
 */
class SATStatus extends AbstractStructBase
{
    /**
     * The mStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mStatus;
    /**
     * The mSatzone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mSatzone;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The mDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mDescription;
    /**
     * The mStatusdatetime_GMT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mStatusdatetime_GMT;
    /**
     * Constructor method for SATStatus
     * @uses SATStatus::setMStatus()
     * @uses SATStatus::setMSatzone()
     * @uses SATStatus::setMId()
     * @uses SATStatus::setMDescription()
     * @uses SATStatus::setMStatusdatetime_GMT()
     * @param int $mStatus
     * @param int $mSatzone
     * @param string $mId
     * @param string $mDescription
     * @param string $mStatusdatetime_GMT
     */
    public function __construct($mStatus = null, $mSatzone = null, $mId = null, $mDescription = null, $mStatusdatetime_GMT = null)
    {
        $this
            ->setMStatus($mStatus)
            ->setMSatzone($mSatzone)
            ->setMId($mId)
            ->setMDescription($mDescription)
            ->setMStatusdatetime_GMT($mStatusdatetime_GMT);
    }
    /**
     * Get mStatus value
     * @return int
     */
    public function getMStatus()
    {
        return $this->mStatus;
    }
    /**
     * Set mStatus value
     * @param int $mStatus
     * @return \StructType\SATStatus
     */
    public function setMStatus($mStatus = null)
    {
        // validation for constraint: int
        if (!is_null($mStatus) && !(is_int($mStatus) || ctype_digit($mStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mStatus, true), gettype($mStatus)), __LINE__);
        }
        $this->mStatus = $mStatus;
        return $this;
    }
    /**
     * Get mSatzone value
     * @return int
     */
    public function getMSatzone()
    {
        return $this->mSatzone;
    }
    /**
     * Set mSatzone value
     * @param int $mSatzone
     * @return \StructType\SATStatus
     */
    public function setMSatzone($mSatzone = null)
    {
        // validation for constraint: int
        if (!is_null($mSatzone) && !(is_int($mSatzone) || ctype_digit($mSatzone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mSatzone, true), gettype($mSatzone)), __LINE__);
        }
        $this->mSatzone = $mSatzone;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\SATStatus
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get mDescription value
     * @return string|null
     */
    public function getMDescription()
    {
        return $this->mDescription;
    }
    /**
     * Set mDescription value
     * @param string $mDescription
     * @return \StructType\SATStatus
     */
    public function setMDescription($mDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mDescription) && !is_string($mDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mDescription, true), gettype($mDescription)), __LINE__);
        }
        $this->mDescription = $mDescription;
        return $this;
    }
    /**
     * Get mStatusdatetime_GMT value
     * @return string|null
     */
    public function getMStatusdatetime_GMT()
    {
        return $this->mStatusdatetime_GMT;
    }
    /**
     * Set mStatusdatetime_GMT value
     * @param string $mStatusdatetime_GMT
     * @return \StructType\SATStatus
     */
    public function setMStatusdatetime_GMT($mStatusdatetime_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($mStatusdatetime_GMT) && !is_string($mStatusdatetime_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mStatusdatetime_GMT, true), gettype($mStatusdatetime_GMT)), __LINE__);
        }
        $this->mStatusdatetime_GMT = $mStatusdatetime_GMT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SATStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
