<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetZonesResponse StructType
 * @subpackage Structs
 */
class GetZonesResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The zoneList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfZoneDef
     */
    public $zoneList;
    /**
     * Constructor method for GetZonesResponse
     * @uses GetZonesResponse::setError_code()
     * @uses GetZonesResponse::setStatus()
     * @uses GetZonesResponse::setDescription()
     * @uses GetZonesResponse::setZoneList()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfZoneDef $zoneList
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfZoneDef $zoneList = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setZoneList($zoneList);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\GetZonesResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\GetZonesResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\GetZonesResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get zoneList value
     * @return \ArrayType\ArrayOfZoneDef|null
     */
    public function getZoneList()
    {
        return $this->zoneList;
    }
    /**
     * Set zoneList value
     * @param \ArrayType\ArrayOfZoneDef $zoneList
     * @return \StructType\GetZonesResponse
     */
    public function setZoneList(\ArrayType\ArrayOfZoneDef $zoneList = null)
    {
        $this->zoneList = $zoneList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetZonesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
