<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventLocation StructType
 * @subpackage Structs
 */
class EventLocation extends AbstractStructBase
{
    /**
     * The regId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The eventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $eventID;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The speed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $speed;
    /**
     * The precision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $precision;
    /**
     * The altitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $altitude;
    /**
     * The heading
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $heading;
    /**
     * The age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $age;
    /**
     * The limit_exceeded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit_exceeded;
    /**
     * The driver_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $driver_id;
    /**
     * The mId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The eventDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eventDescription;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The gps_GMT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gps_GMT;
    /**
     * The system_GMT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_GMT;
    /**
     * The driver_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driver_name;
    /**
     * Constructor method for EventLocation
     * @uses EventLocation::setRegId()
     * @uses EventLocation::setEventID()
     * @uses EventLocation::setLatitude()
     * @uses EventLocation::setLongitude()
     * @uses EventLocation::setSpeed()
     * @uses EventLocation::setPrecision()
     * @uses EventLocation::setAltitude()
     * @uses EventLocation::setHeading()
     * @uses EventLocation::setAge()
     * @uses EventLocation::setLimit_exceeded()
     * @uses EventLocation::setDriver_id()
     * @uses EventLocation::setMId()
     * @uses EventLocation::setEventDescription()
     * @uses EventLocation::setAddress()
     * @uses EventLocation::setGps_GMT()
     * @uses EventLocation::setSystem_GMT()
     * @uses EventLocation::setDriver_name()
     * @param int $regId
     * @param int $eventID
     * @param float $latitude
     * @param float $longitude
     * @param int $speed
     * @param int $precision
     * @param int $altitude
     * @param int $heading
     * @param int $age
     * @param int $limit_exceeded
     * @param int $driver_id
     * @param string $mId
     * @param string $eventDescription
     * @param string $address
     * @param string $gps_GMT
     * @param string $system_GMT
     * @param string $driver_name
     */
    public function __construct($regId = null, $eventID = null, $latitude = null, $longitude = null, $speed = null, $precision = null, $altitude = null, $heading = null, $age = null, $limit_exceeded = null, $driver_id = null, $mId = null, $eventDescription = null, $address = null, $gps_GMT = null, $system_GMT = null, $driver_name = null)
    {
        $this
            ->setRegId($regId)
            ->setEventID($eventID)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSpeed($speed)
            ->setPrecision($precision)
            ->setAltitude($altitude)
            ->setHeading($heading)
            ->setAge($age)
            ->setLimit_exceeded($limit_exceeded)
            ->setDriver_id($driver_id)
            ->setMId($mId)
            ->setEventDescription($eventDescription)
            ->setAddress($address)
            ->setGps_GMT($gps_GMT)
            ->setSystem_GMT($system_GMT)
            ->setDriver_name($driver_name);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\EventLocation
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get eventID value
     * @return int
     */
    public function getEventID()
    {
        return $this->eventID;
    }
    /**
     * Set eventID value
     * @param int $eventID
     * @return \StructType\EventLocation
     */
    public function setEventID($eventID = null)
    {
        // validation for constraint: int
        if (!is_null($eventID) && !(is_int($eventID) || ctype_digit($eventID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventID, true), gettype($eventID)), __LINE__);
        }
        $this->eventID = $eventID;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\EventLocation
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\EventLocation
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param int $speed
     * @return \StructType\EventLocation
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->speed = $speed;
        return $this;
    }
    /**
     * Get precision value
     * @return int
     */
    public function getPrecision()
    {
        return $this->precision;
    }
    /**
     * Set precision value
     * @param int $precision
     * @return \StructType\EventLocation
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !(is_int($precision) || ctype_digit($precision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($precision, true), gettype($precision)), __LINE__);
        }
        $this->precision = $precision;
        return $this;
    }
    /**
     * Get altitude value
     * @return int
     */
    public function getAltitude()
    {
        return $this->altitude;
    }
    /**
     * Set altitude value
     * @param int $altitude
     * @return \StructType\EventLocation
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: int
        if (!is_null($altitude) && !(is_int($altitude) || ctype_digit($altitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        $this->altitude = $altitude;
        return $this;
    }
    /**
     * Get heading value
     * @return int
     */
    public function getHeading()
    {
        return $this->heading;
    }
    /**
     * Set heading value
     * @param int $heading
     * @return \StructType\EventLocation
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: int
        if (!is_null($heading) && !(is_int($heading) || ctype_digit($heading))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heading, true), gettype($heading)), __LINE__);
        }
        $this->heading = $heading;
        return $this;
    }
    /**
     * Get age value
     * @return int
     */
    public function getAge()
    {
        return $this->age;
    }
    /**
     * Set age value
     * @param int $age
     * @return \StructType\EventLocation
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->age = $age;
        return $this;
    }
    /**
     * Get limit_exceeded value
     * @return int
     */
    public function getLimit_exceeded()
    {
        return $this->limit_exceeded;
    }
    /**
     * Set limit_exceeded value
     * @param int $limit_exceeded
     * @return \StructType\EventLocation
     */
    public function setLimit_exceeded($limit_exceeded = null)
    {
        // validation for constraint: int
        if (!is_null($limit_exceeded) && !(is_int($limit_exceeded) || ctype_digit($limit_exceeded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit_exceeded, true), gettype($limit_exceeded)), __LINE__);
        }
        $this->limit_exceeded = $limit_exceeded;
        return $this;
    }
    /**
     * Get driver_id value
     * @return int
     */
    public function getDriver_id()
    {
        return $this->driver_id;
    }
    /**
     * Set driver_id value
     * @param int $driver_id
     * @return \StructType\EventLocation
     */
    public function setDriver_id($driver_id = null)
    {
        // validation for constraint: int
        if (!is_null($driver_id) && !(is_int($driver_id) || ctype_digit($driver_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driver_id, true), gettype($driver_id)), __LINE__);
        }
        $this->driver_id = $driver_id;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\EventLocation
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get eventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->eventDescription;
    }
    /**
     * Set eventDescription value
     * @param string $eventDescription
     * @return \StructType\EventLocation
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->eventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\EventLocation
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get gps_GMT value
     * @return string|null
     */
    public function getGps_GMT()
    {
        return $this->gps_GMT;
    }
    /**
     * Set gps_GMT value
     * @param string $gps_GMT
     * @return \StructType\EventLocation
     */
    public function setGps_GMT($gps_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($gps_GMT) && !is_string($gps_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_GMT, true), gettype($gps_GMT)), __LINE__);
        }
        $this->gps_GMT = $gps_GMT;
        return $this;
    }
    /**
     * Get system_GMT value
     * @return string|null
     */
    public function getSystem_GMT()
    {
        return $this->system_GMT;
    }
    /**
     * Set system_GMT value
     * @param string $system_GMT
     * @return \StructType\EventLocation
     */
    public function setSystem_GMT($system_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($system_GMT) && !is_string($system_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_GMT, true), gettype($system_GMT)), __LINE__);
        }
        $this->system_GMT = $system_GMT;
        return $this;
    }
    /**
     * Get driver_name value
     * @return string|null
     */
    public function getDriver_name()
    {
        return $this->driver_name;
    }
    /**
     * Set driver_name value
     * @param string $driver_name
     * @return \StructType\EventLocation
     */
    public function setDriver_name($driver_name = null)
    {
        // validation for constraint: string
        if (!is_null($driver_name) && !is_string($driver_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver_name, true), gettype($driver_name)), __LINE__);
        }
        $this->driver_name = $driver_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
