<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETI ServiceType
 * @subpackage Services
 */
class GETI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_ItinerariesHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historia de los itinerarios. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItinerariesHistory $parameters
     * @return \StructType\GET_ItinerariesHistoryResponse|bool
     */
    public function GET_ItinerariesHistory(\StructType\GET_ItinerariesHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ItinerariesHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_ItinerariesHistory_v2
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de los itinerarios. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItinerariesHistory_v2 $parameters
     * @return \StructType\GET_ItinerariesHistory_v2Response|bool
     */
    public function GET_ItinerariesHistory_v2(\StructType\GET_ItinerariesHistory_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ItinerariesHistory_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_Itineraries
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el listado de los itinerarios creados en el grupo. Si no se especifica un grupo devuelve lo de toda la flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_Itineraries $parameters
     * @return \StructType\GET_ItinerariesResponse|bool
     */
    public function GET_Itineraries(\StructType\GET_Itineraries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_Itineraries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_ItPointHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve historial de llegadas a un punto de control para un itinerario específico o para todo el grupo, debe especificar sólo uno de los dos. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss y
     * corresponden a la fecha y hora de inicio del itinerario.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ItPointHistory $parameters
     * @return \StructType\GET_ItPointHistoryResponse|bool
     */
    public function GET_ItPointHistory(\StructType\GET_ItPointHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ItPointHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_ItinerariesHistoryResponse|\StructType\GET_ItinerariesHistory_v2Response|\StructType\GET_ItinerariesResponse|\StructType\GET_ItPointHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
