<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GET_ItPointHistory StructType
 * @subpackage Structs
 */
class GET_ItPointHistory extends AbstractStructBase
{
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupId;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Itinerary;
    /**
     * The GroupGeofenceIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupGeofenceIndex;
    /**
     * The UTC_datetime_init
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UTC_datetime_init;
    /**
     * The UTC_datetime_end
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UTC_datetime_end;
    /**
     * Constructor method for GET_ItPointHistory
     * @uses GET_ItPointHistory::setUser()
     * @uses GET_ItPointHistory::setPassword()
     * @uses GET_ItPointHistory::setGroupId()
     * @uses GET_ItPointHistory::setItinerary()
     * @uses GET_ItPointHistory::setGroupGeofenceIndex()
     * @uses GET_ItPointHistory::setUTC_datetime_init()
     * @uses GET_ItPointHistory::setUTC_datetime_end()
     * @param string $user
     * @param string $password
     * @param string $groupId
     * @param string $itinerary
     * @param string $groupGeofenceIndex
     * @param string $uTC_datetime_init
     * @param string $uTC_datetime_end
     */
    public function __construct($user = null, $password = null, $groupId = null, $itinerary = null, $groupGeofenceIndex = null, $uTC_datetime_init = null, $uTC_datetime_end = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setGroupId($groupId)
            ->setItinerary($itinerary)
            ->setGroupGeofenceIndex($groupGeofenceIndex)
            ->setUTC_datetime_init($uTC_datetime_init)
            ->setUTC_datetime_end($uTC_datetime_end);
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\GET_ItPointHistory
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GET_ItPointHistory
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\GET_ItPointHistory
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return string|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param string $itinerary
     * @return \StructType\GET_ItPointHistory
     */
    public function setItinerary($itinerary = null)
    {
        // validation for constraint: string
        if (!is_null($itinerary) && !is_string($itinerary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itinerary)), __LINE__);
        }
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get GroupGeofenceIndex value
     * @return string|null
     */
    public function getGroupGeofenceIndex()
    {
        return $this->GroupGeofenceIndex;
    }
    /**
     * Set GroupGeofenceIndex value
     * @param string $groupGeofenceIndex
     * @return \StructType\GET_ItPointHistory
     */
    public function setGroupGeofenceIndex($groupGeofenceIndex = null)
    {
        // validation for constraint: string
        if (!is_null($groupGeofenceIndex) && !is_string($groupGeofenceIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupGeofenceIndex)), __LINE__);
        }
        $this->GroupGeofenceIndex = $groupGeofenceIndex;
        return $this;
    }
    /**
     * Get UTC_datetime_init value
     * @return string|null
     */
    public function getUTC_datetime_init()
    {
        return $this->UTC_datetime_init;
    }
    /**
     * Set UTC_datetime_init value
     * @param string $uTC_datetime_init
     * @return \StructType\GET_ItPointHistory
     */
    public function setUTC_datetime_init($uTC_datetime_init = null)
    {
        // validation for constraint: string
        if (!is_null($uTC_datetime_init) && !is_string($uTC_datetime_init)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uTC_datetime_init)), __LINE__);
        }
        $this->UTC_datetime_init = $uTC_datetime_init;
        return $this;
    }
    /**
     * Get UTC_datetime_end value
     * @return string|null
     */
    public function getUTC_datetime_end()
    {
        return $this->UTC_datetime_end;
    }
    /**
     * Set UTC_datetime_end value
     * @param string $uTC_datetime_end
     * @return \StructType\GET_ItPointHistory
     */
    public function setUTC_datetime_end($uTC_datetime_end = null)
    {
        // validation for constraint: string
        if (!is_null($uTC_datetime_end) && !is_string($uTC_datetime_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uTC_datetime_end)), __LINE__);
        }
        $this->UTC_datetime_end = $uTC_datetime_end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GET_ItPointHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
