<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETS ServiceType
 * @subpackage Services
 */
class GETS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_ServiceInfo
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve la información de un servicio.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ServiceInfo $parameters
     * @return \StructType\GET_ServiceInfoResponse|bool
     */
    public function GET_ServiceInfo(\StructType\GET_ServiceInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ServiceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_ServicesHistory
     * Meta informations extracted from the WSDL
     * - documentation: Devuelve el historial de servicios del un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_ServicesHistory $parameters
     * @return \StructType\GET_ServicesHistoryResponse|bool
     */
    public function GET_ServicesHistory(\StructType\GET_ServicesHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GET_ServicesHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_ServiceInfoResponse|\StructType\GET_ServicesHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
