<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileGeofence ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileGeofence extends AbstractStructArrayBase
{
    /**
     * The MobileGeofence
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MobileGeofence[]
     */
    public $MobileGeofence;
    /**
     * Constructor method for ArrayOfMobileGeofence
     * @uses ArrayOfMobileGeofence::setMobileGeofence()
     * @param \StructType\MobileGeofence[] $mobileGeofence
     */
    public function __construct(array $mobileGeofence = array())
    {
        $this
            ->setMobileGeofence($mobileGeofence);
    }
    /**
     * Get MobileGeofence value
     * @return \StructType\MobileGeofence[]|null
     */
    public function getMobileGeofence()
    {
        return $this->MobileGeofence;
    }
    /**
     * Set MobileGeofence value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGeofence[] $mobileGeofence
     * @return \ArrayType\ArrayOfMobileGeofence
     */
    public function setMobileGeofence(array $mobileGeofence = array())
    {
        foreach ($mobileGeofence as $arrayOfMobileGeofenceMobileGeofenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileGeofenceMobileGeofenceItem instanceof \StructType\MobileGeofence) {
                throw new \InvalidArgumentException(sprintf('The MobileGeofence property can only contain items of \StructType\MobileGeofence, "%s" given', is_object($arrayOfMobileGeofenceMobileGeofenceItem) ? get_class($arrayOfMobileGeofenceMobileGeofenceItem) : gettype($arrayOfMobileGeofenceMobileGeofenceItem)), __LINE__);
            }
        }
        $this->MobileGeofence = $mobileGeofence;
        return $this;
    }
    /**
     * Add item to MobileGeofence value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGeofence $item
     * @return \ArrayType\ArrayOfMobileGeofence
     */
    public function addToMobileGeofence(\StructType\MobileGeofence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileGeofence) {
            throw new \InvalidArgumentException(sprintf('The MobileGeofence property can only contain items of \StructType\MobileGeofence, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MobileGeofence[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileGeofence|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileGeofence|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileGeofence|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileGeofence|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileGeofence|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileGeofence
     */
    public function getAttributeName()
    {
        return 'MobileGeofence';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMobileGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
