<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserProfile StructType
 * @subpackage Structs
 */
class UserProfile extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The FleetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FleetId;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $profile;
    /**
     * The attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attributes;
    /**
     * Constructor method for UserProfile
     * @uses UserProfile::setAccountId()
     * @uses UserProfile::setFleetId()
     * @uses UserProfile::setGroupId()
     * @uses UserProfile::setProfile()
     * @uses UserProfile::setAttributes()
     * @param int $accountId
     * @param int $fleetId
     * @param int $groupId
     * @param string $profile
     * @param string $attributes
     */
    public function __construct($accountId = null, $fleetId = null, $groupId = null, $profile = null, $attributes = null)
    {
        $this
            ->setAccountId($accountId)
            ->setFleetId($fleetId)
            ->setGroupId($groupId)
            ->setProfile($profile)
            ->setAttributes($attributes);
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\UserProfile
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !is_numeric($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get FleetId value
     * @return int
     */
    public function getFleetId()
    {
        return $this->FleetId;
    }
    /**
     * Set FleetId value
     * @param int $fleetId
     * @return \StructType\UserProfile
     */
    public function setFleetId($fleetId = null)
    {
        // validation for constraint: int
        if (!is_null($fleetId) && !is_numeric($fleetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fleetId)), __LINE__);
        }
        $this->FleetId = $fleetId;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \StructType\UserProfile
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \StructType\UserProfile
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get attributes value
     * @return string|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param string $attributes
     * @return \StructType\UserProfile
     */
    public function setAttributes($attributes = null)
    {
        // validation for constraint: string
        if (!is_null($attributes) && !is_string($attributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributes)), __LINE__);
        }
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
