<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceStatusLog StructType
 * @subpackage Structs
 */
class ServiceStatusLog extends AbstractStructBase
{
    /**
     * The regId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $status;
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The datetime_GMT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $datetime_GMT;
    /**
     * Constructor method for ServiceStatusLog
     * @uses ServiceStatusLog::setRegId()
     * @uses ServiceStatusLog::setStatus()
     * @uses ServiceStatusLog::setUser()
     * @uses ServiceStatusLog::setComments()
     * @uses ServiceStatusLog::setDatetime_GMT()
     * @param int $regId
     * @param int $status
     * @param string $user
     * @param string $comments
     * @param string $datetime_GMT
     */
    public function __construct($regId = null, $status = null, $user = null, $comments = null, $datetime_GMT = null)
    {
        $this
            ->setRegId($regId)
            ->setStatus($status)
            ->setUser($user)
            ->setComments($comments)
            ->setDatetime_GMT($datetime_GMT);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\ServiceStatusLog
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !is_numeric($regId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\ServiceStatusLog
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\ServiceStatusLog
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\ServiceStatusLog
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get datetime_GMT value
     * @return string|null
     */
    public function getDatetime_GMT()
    {
        return $this->datetime_GMT;
    }
    /**
     * Set datetime_GMT value
     * @param string $datetime_GMT
     * @return \StructType\ServiceStatusLog
     */
    public function setDatetime_GMT($datetime_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($datetime_GMT) && !is_string($datetime_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetime_GMT)), __LINE__);
        }
        $this->datetime_GMT = $datetime_GMT;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceStatusLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
