<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItPoint StructType
 * @subpackage Structs
 */
class ItPoint extends AbstractStructBase
{
    /**
     * The point_index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $point_index;
    /**
     * The geofence_index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $geofence_index;
    /**
     * The time_min
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $time_min;
    /**
     * The time_max
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $time_max;
    /**
     * The geofence_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geofence_name;
    /**
     * Constructor method for ItPoint
     * @uses ItPoint::setPoint_index()
     * @uses ItPoint::setGeofence_index()
     * @uses ItPoint::setTime_min()
     * @uses ItPoint::setTime_max()
     * @uses ItPoint::setGeofence_name()
     * @param int $point_index
     * @param int $geofence_index
     * @param int $time_min
     * @param int $time_max
     * @param string $geofence_name
     */
    public function __construct($point_index = null, $geofence_index = null, $time_min = null, $time_max = null, $geofence_name = null)
    {
        $this
            ->setPoint_index($point_index)
            ->setGeofence_index($geofence_index)
            ->setTime_min($time_min)
            ->setTime_max($time_max)
            ->setGeofence_name($geofence_name);
    }
    /**
     * Get point_index value
     * @return int
     */
    public function getPoint_index()
    {
        return $this->point_index;
    }
    /**
     * Set point_index value
     * @param int $point_index
     * @return \StructType\ItPoint
     */
    public function setPoint_index($point_index = null)
    {
        // validation for constraint: int
        if (!is_null($point_index) && !is_numeric($point_index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($point_index)), __LINE__);
        }
        $this->point_index = $point_index;
        return $this;
    }
    /**
     * Get geofence_index value
     * @return int
     */
    public function getGeofence_index()
    {
        return $this->geofence_index;
    }
    /**
     * Set geofence_index value
     * @param int $geofence_index
     * @return \StructType\ItPoint
     */
    public function setGeofence_index($geofence_index = null)
    {
        // validation for constraint: int
        if (!is_null($geofence_index) && !is_numeric($geofence_index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geofence_index)), __LINE__);
        }
        $this->geofence_index = $geofence_index;
        return $this;
    }
    /**
     * Get time_min value
     * @return int
     */
    public function getTime_min()
    {
        return $this->time_min;
    }
    /**
     * Set time_min value
     * @param int $time_min
     * @return \StructType\ItPoint
     */
    public function setTime_min($time_min = null)
    {
        // validation for constraint: int
        if (!is_null($time_min) && !is_numeric($time_min)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($time_min)), __LINE__);
        }
        $this->time_min = $time_min;
        return $this;
    }
    /**
     * Get time_max value
     * @return int
     */
    public function getTime_max()
    {
        return $this->time_max;
    }
    /**
     * Set time_max value
     * @param int $time_max
     * @return \StructType\ItPoint
     */
    public function setTime_max($time_max = null)
    {
        // validation for constraint: int
        if (!is_null($time_max) && !is_numeric($time_max)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($time_max)), __LINE__);
        }
        $this->time_max = $time_max;
        return $this;
    }
    /**
     * Get geofence_name value
     * @return string|null
     */
    public function getGeofence_name()
    {
        return $this->geofence_name;
    }
    /**
     * Set geofence_name value
     * @param string $geofence_name
     * @return \StructType\ItPoint
     */
    public function setGeofence_name($geofence_name = null)
    {
        // validation for constraint: string
        if (!is_null($geofence_name) && !is_string($geofence_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geofence_name)), __LINE__);
        }
        $this->geofence_name = $geofence_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
