<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FleetListResponse StructType
 * @subpackage Structs
 */
class FleetListResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fleetList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFleetInfo
     */
    public $fleetList;
    /**
     * Constructor method for FleetListResponse
     * @uses FleetListResponse::setError_code()
     * @uses FleetListResponse::setStatus()
     * @uses FleetListResponse::setDescription()
     * @uses FleetListResponse::setFleetList()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfFleetInfo $fleetList
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfFleetInfo $fleetList = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setFleetList($fleetList);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\FleetListResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !is_numeric($error_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\FleetListResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FleetListResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fleetList value
     * @return \ArrayType\ArrayOfFleetInfo|null
     */
    public function getFleetList()
    {
        return $this->fleetList;
    }
    /**
     * Set fleetList value
     * @param \ArrayType\ArrayOfFleetInfo $fleetList
     * @return \StructType\FleetListResponse
     */
    public function setFleetList(\ArrayType\ArrayOfFleetInfo $fleetList = null)
    {
        $this->fleetList = $fleetList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FleetListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
