<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The aBuildingFound
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $aBuildingFound;
    /**
     * The aPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Point
     */
    public $aPoint;
    /**
     * The aLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aLabel;
    /**
     * The aSettlement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aSettlement;
    /**
     * The aSettlementCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aSettlementCode;
    /**
     * The aMunicipality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aMunicipality;
    /**
     * The aMunicipalityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aMunicipalityCode;
    /**
     * The aState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aState;
    /**
     * The aStateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aStateCode;
    /**
     * The aCountryISO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aCountryISO;
    /**
     * Constructor method for Address
     * @uses Address::setABuildingFound()
     * @uses Address::setAPoint()
     * @uses Address::setALabel()
     * @uses Address::setASettlement()
     * @uses Address::setASettlementCode()
     * @uses Address::setAMunicipality()
     * @uses Address::setAMunicipalityCode()
     * @uses Address::setAState()
     * @uses Address::setAStateCode()
     * @uses Address::setACountryISO()
     * @param bool $aBuildingFound
     * @param \StructType\Point $aPoint
     * @param string $aLabel
     * @param string $aSettlement
     * @param string $aSettlementCode
     * @param string $aMunicipality
     * @param string $aMunicipalityCode
     * @param string $aState
     * @param string $aStateCode
     * @param string $aCountryISO
     */
    public function __construct($aBuildingFound = null, \StructType\Point $aPoint = null, $aLabel = null, $aSettlement = null, $aSettlementCode = null, $aMunicipality = null, $aMunicipalityCode = null, $aState = null, $aStateCode = null, $aCountryISO = null)
    {
        $this
            ->setABuildingFound($aBuildingFound)
            ->setAPoint($aPoint)
            ->setALabel($aLabel)
            ->setASettlement($aSettlement)
            ->setASettlementCode($aSettlementCode)
            ->setAMunicipality($aMunicipality)
            ->setAMunicipalityCode($aMunicipalityCode)
            ->setAState($aState)
            ->setAStateCode($aStateCode)
            ->setACountryISO($aCountryISO);
    }
    /**
     * Get aBuildingFound value
     * @return bool
     */
    public function getABuildingFound()
    {
        return $this->aBuildingFound;
    }
    /**
     * Set aBuildingFound value
     * @param bool $aBuildingFound
     * @return \StructType\Address
     */
    public function setABuildingFound($aBuildingFound = null)
    {
        // validation for constraint: boolean
        if (!is_null($aBuildingFound) && !is_bool($aBuildingFound)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aBuildingFound)), __LINE__);
        }
        $this->aBuildingFound = $aBuildingFound;
        return $this;
    }
    /**
     * Get aPoint value
     * @return \StructType\Point
     */
    public function getAPoint()
    {
        return $this->aPoint;
    }
    /**
     * Set aPoint value
     * @param \StructType\Point $aPoint
     * @return \StructType\Address
     */
    public function setAPoint(\StructType\Point $aPoint = null)
    {
        $this->aPoint = $aPoint;
        return $this;
    }
    /**
     * Get aLabel value
     * @return string|null
     */
    public function getALabel()
    {
        return $this->aLabel;
    }
    /**
     * Set aLabel value
     * @param string $aLabel
     * @return \StructType\Address
     */
    public function setALabel($aLabel = null)
    {
        // validation for constraint: string
        if (!is_null($aLabel) && !is_string($aLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLabel)), __LINE__);
        }
        $this->aLabel = $aLabel;
        return $this;
    }
    /**
     * Get aSettlement value
     * @return string|null
     */
    public function getASettlement()
    {
        return $this->aSettlement;
    }
    /**
     * Set aSettlement value
     * @param string $aSettlement
     * @return \StructType\Address
     */
    public function setASettlement($aSettlement = null)
    {
        // validation for constraint: string
        if (!is_null($aSettlement) && !is_string($aSettlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aSettlement)), __LINE__);
        }
        $this->aSettlement = $aSettlement;
        return $this;
    }
    /**
     * Get aSettlementCode value
     * @return string|null
     */
    public function getASettlementCode()
    {
        return $this->aSettlementCode;
    }
    /**
     * Set aSettlementCode value
     * @param string $aSettlementCode
     * @return \StructType\Address
     */
    public function setASettlementCode($aSettlementCode = null)
    {
        // validation for constraint: string
        if (!is_null($aSettlementCode) && !is_string($aSettlementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aSettlementCode)), __LINE__);
        }
        $this->aSettlementCode = $aSettlementCode;
        return $this;
    }
    /**
     * Get aMunicipality value
     * @return string|null
     */
    public function getAMunicipality()
    {
        return $this->aMunicipality;
    }
    /**
     * Set aMunicipality value
     * @param string $aMunicipality
     * @return \StructType\Address
     */
    public function setAMunicipality($aMunicipality = null)
    {
        // validation for constraint: string
        if (!is_null($aMunicipality) && !is_string($aMunicipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMunicipality)), __LINE__);
        }
        $this->aMunicipality = $aMunicipality;
        return $this;
    }
    /**
     * Get aMunicipalityCode value
     * @return string|null
     */
    public function getAMunicipalityCode()
    {
        return $this->aMunicipalityCode;
    }
    /**
     * Set aMunicipalityCode value
     * @param string $aMunicipalityCode
     * @return \StructType\Address
     */
    public function setAMunicipalityCode($aMunicipalityCode = null)
    {
        // validation for constraint: string
        if (!is_null($aMunicipalityCode) && !is_string($aMunicipalityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMunicipalityCode)), __LINE__);
        }
        $this->aMunicipalityCode = $aMunicipalityCode;
        return $this;
    }
    /**
     * Get aState value
     * @return string|null
     */
    public function getAState()
    {
        return $this->aState;
    }
    /**
     * Set aState value
     * @param string $aState
     * @return \StructType\Address
     */
    public function setAState($aState = null)
    {
        // validation for constraint: string
        if (!is_null($aState) && !is_string($aState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aState)), __LINE__);
        }
        $this->aState = $aState;
        return $this;
    }
    /**
     * Get aStateCode value
     * @return string|null
     */
    public function getAStateCode()
    {
        return $this->aStateCode;
    }
    /**
     * Set aStateCode value
     * @param string $aStateCode
     * @return \StructType\Address
     */
    public function setAStateCode($aStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($aStateCode) && !is_string($aStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aStateCode)), __LINE__);
        }
        $this->aStateCode = $aStateCode;
        return $this;
    }
    /**
     * Get aCountryISO value
     * @return string|null
     */
    public function getACountryISO()
    {
        return $this->aCountryISO;
    }
    /**
     * Set aCountryISO value
     * @param string $aCountryISO
     * @return \StructType\Address
     */
    public function setACountryISO($aCountryISO = null)
    {
        // validation for constraint: string
        if (!is_null($aCountryISO) && !is_string($aCountryISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCountryISO)), __LINE__);
        }
        $this->aCountryISO = $aCountryISO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
