<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReferencePointStruct ArrayType
 * @subpackage Arrays
 */
class ArrayOfReferencePointStruct extends AbstractStructArrayBase
{
    /**
     * The ReferencePointStruct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReferencePointStruct[]
     */
    public $ReferencePointStruct;
    /**
     * Constructor method for ArrayOfReferencePointStruct
     * @uses ArrayOfReferencePointStruct::setReferencePointStruct()
     * @param \StructType\ReferencePointStruct[] $referencePointStruct
     */
    public function __construct(array $referencePointStruct = array())
    {
        $this
            ->setReferencePointStruct($referencePointStruct);
    }
    /**
     * Get ReferencePointStruct value
     * @return \StructType\ReferencePointStruct[]|null
     */
    public function getReferencePointStruct()
    {
        return $this->ReferencePointStruct;
    }
    /**
     * Set ReferencePointStruct value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencePointStruct[] $referencePointStruct
     * @return \ArrayType\ArrayOfReferencePointStruct
     */
    public function setReferencePointStruct(array $referencePointStruct = array())
    {
        foreach ($referencePointStruct as $arrayOfReferencePointStructReferencePointStructItem) {
            // validation for constraint: itemType
            if (!$arrayOfReferencePointStructReferencePointStructItem instanceof \StructType\ReferencePointStruct) {
                throw new \InvalidArgumentException(sprintf('The ReferencePointStruct property can only contain items of \StructType\ReferencePointStruct, "%s" given', is_object($arrayOfReferencePointStructReferencePointStructItem) ? get_class($arrayOfReferencePointStructReferencePointStructItem) : gettype($arrayOfReferencePointStructReferencePointStructItem)), __LINE__);
            }
        }
        $this->ReferencePointStruct = $referencePointStruct;
        return $this;
    }
    /**
     * Add item to ReferencePointStruct value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencePointStruct $item
     * @return \ArrayType\ArrayOfReferencePointStruct
     */
    public function addToReferencePointStruct(\StructType\ReferencePointStruct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferencePointStruct) {
            throw new \InvalidArgumentException(sprintf('The ReferencePointStruct property can only contain items of \StructType\ReferencePointStruct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReferencePointStruct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReferencePointStruct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReferencePointStruct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReferencePointStruct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReferencePointStruct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReferencePointStruct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReferencePointStruct
     */
    public function getAttributeName()
    {
        return 'ReferencePointStruct';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReferencePointStruct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
