<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOdometer ArrayType
 * @subpackage Arrays
 */
class ArrayOfOdometer extends AbstractStructArrayBase
{
    /**
     * The Odometer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Odometer[]
     */
    public $Odometer;
    /**
     * Constructor method for ArrayOfOdometer
     * @uses ArrayOfOdometer::setOdometer()
     * @param \StructType\Odometer[] $odometer
     */
    public function __construct(array $odometer = array())
    {
        $this
            ->setOdometer($odometer);
    }
    /**
     * Get Odometer value
     * @return \StructType\Odometer[]|null
     */
    public function getOdometer()
    {
        return $this->Odometer;
    }
    /**
     * Set Odometer value
     * @throws \InvalidArgumentException
     * @param \StructType\Odometer[] $odometer
     * @return \ArrayType\ArrayOfOdometer
     */
    public function setOdometer(array $odometer = array())
    {
        foreach ($odometer as $arrayOfOdometerOdometerItem) {
            // validation for constraint: itemType
            if (!$arrayOfOdometerOdometerItem instanceof \StructType\Odometer) {
                throw new \InvalidArgumentException(sprintf('The Odometer property can only contain items of \StructType\Odometer, "%s" given', is_object($arrayOfOdometerOdometerItem) ? get_class($arrayOfOdometerOdometerItem) : gettype($arrayOfOdometerOdometerItem)), __LINE__);
            }
        }
        $this->Odometer = $odometer;
        return $this;
    }
    /**
     * Add item to Odometer value
     * @throws \InvalidArgumentException
     * @param \StructType\Odometer $item
     * @return \ArrayType\ArrayOfOdometer
     */
    public function addToOdometer(\StructType\Odometer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Odometer) {
            throw new \InvalidArgumentException(sprintf('The Odometer property can only contain items of \StructType\Odometer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Odometer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Odometer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Odometer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Odometer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Odometer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Odometer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Odometer
     */
    public function getAttributeName()
    {
        return 'Odometer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOdometer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
