<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileGroup extends AbstractStructArrayBase
{
    /**
     * The MobileGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MobileGroup[]
     */
    public $MobileGroup;
    /**
     * Constructor method for ArrayOfMobileGroup
     * @uses ArrayOfMobileGroup::setMobileGroup()
     * @param \StructType\MobileGroup[] $mobileGroup
     */
    public function __construct(array $mobileGroup = array())
    {
        $this
            ->setMobileGroup($mobileGroup);
    }
    /**
     * Get MobileGroup value
     * @return \StructType\MobileGroup[]|null
     */
    public function getMobileGroup()
    {
        return $this->MobileGroup;
    }
    /**
     * Set MobileGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGroup[] $mobileGroup
     * @return \ArrayType\ArrayOfMobileGroup
     */
    public function setMobileGroup(array $mobileGroup = array())
    {
        foreach ($mobileGroup as $arrayOfMobileGroupMobileGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileGroupMobileGroupItem instanceof \StructType\MobileGroup) {
                throw new \InvalidArgumentException(sprintf('The MobileGroup property can only contain items of \StructType\MobileGroup, "%s" given', is_object($arrayOfMobileGroupMobileGroupItem) ? get_class($arrayOfMobileGroupMobileGroupItem) : gettype($arrayOfMobileGroupMobileGroupItem)), __LINE__);
            }
        }
        $this->MobileGroup = $mobileGroup;
        return $this;
    }
    /**
     * Add item to MobileGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGroup $item
     * @return \ArrayType\ArrayOfMobileGroup
     */
    public function addToMobileGroup(\StructType\MobileGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileGroup) {
            throw new \InvalidArgumentException(sprintf('The MobileGroup property can only contain items of \StructType\MobileGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MobileGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileGroup
     */
    public function getAttributeName()
    {
        return 'MobileGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMobileGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
