<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItinerary ArrayType
 * @subpackage Arrays
 */
class ArrayOfItinerary extends AbstractStructArrayBase
{
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Itinerary[]
     */
    public $Itinerary;
    /**
     * Constructor method for ArrayOfItinerary
     * @uses ArrayOfItinerary::setItinerary()
     * @param \StructType\Itinerary[] $itinerary
     */
    public function __construct(array $itinerary = array())
    {
        $this
            ->setItinerary($itinerary);
    }
    /**
     * Get Itinerary value
     * @return \StructType\Itinerary[]|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @throws \InvalidArgumentException
     * @param \StructType\Itinerary[] $itinerary
     * @return \ArrayType\ArrayOfItinerary
     */
    public function setItinerary(array $itinerary = array())
    {
        foreach ($itinerary as $arrayOfItineraryItineraryItem) {
            // validation for constraint: itemType
            if (!$arrayOfItineraryItineraryItem instanceof \StructType\Itinerary) {
                throw new \InvalidArgumentException(sprintf('The Itinerary property can only contain items of \StructType\Itinerary, "%s" given', is_object($arrayOfItineraryItineraryItem) ? get_class($arrayOfItineraryItineraryItem) : gettype($arrayOfItineraryItineraryItem)), __LINE__);
            }
        }
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Add item to Itinerary value
     * @throws \InvalidArgumentException
     * @param \StructType\Itinerary $item
     * @return \ArrayType\ArrayOfItinerary
     */
    public function addToItinerary(\StructType\Itinerary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Itinerary) {
            throw new \InvalidArgumentException(sprintf('The Itinerary property can only contain items of \StructType\Itinerary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Itinerary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Itinerary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Itinerary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Itinerary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Itinerary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Itinerary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Itinerary
     */
    public function getAttributeName()
    {
        return 'Itinerary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
