<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItPoint ArrayType
 * @subpackage Arrays
 */
class ArrayOfItPoint extends AbstractStructArrayBase
{
    /**
     * The ItPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItPoint[]
     */
    public $ItPoint;
    /**
     * Constructor method for ArrayOfItPoint
     * @uses ArrayOfItPoint::setItPoint()
     * @param \StructType\ItPoint[] $itPoint
     */
    public function __construct(array $itPoint = array())
    {
        $this
            ->setItPoint($itPoint);
    }
    /**
     * Get ItPoint value
     * @return \StructType\ItPoint[]|null
     */
    public function getItPoint()
    {
        return $this->ItPoint;
    }
    /**
     * Set ItPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ItPoint[] $itPoint
     * @return \ArrayType\ArrayOfItPoint
     */
    public function setItPoint(array $itPoint = array())
    {
        foreach ($itPoint as $arrayOfItPointItPointItem) {
            // validation for constraint: itemType
            if (!$arrayOfItPointItPointItem instanceof \StructType\ItPoint) {
                throw new \InvalidArgumentException(sprintf('The ItPoint property can only contain items of \StructType\ItPoint, "%s" given', is_object($arrayOfItPointItPointItem) ? get_class($arrayOfItPointItPointItem) : gettype($arrayOfItPointItPointItem)), __LINE__);
            }
        }
        $this->ItPoint = $itPoint;
        return $this;
    }
    /**
     * Add item to ItPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ItPoint $item
     * @return \ArrayType\ArrayOfItPoint
     */
    public function addToItPoint(\StructType\ItPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItPoint) {
            throw new \InvalidArgumentException(sprintf('The ItPoint property can only contain items of \StructType\ItPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItPoint
     */
    public function getAttributeName()
    {
        return 'ItPoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
