<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfItLog extends AbstractStructArrayBase
{
    /**
     * The ItLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItLog[]
     */
    public $ItLog;
    /**
     * Constructor method for ArrayOfItLog
     * @uses ArrayOfItLog::setItLog()
     * @param \StructType\ItLog[] $itLog
     */
    public function __construct(array $itLog = array())
    {
        $this
            ->setItLog($itLog);
    }
    /**
     * Get ItLog value
     * @return \StructType\ItLog[]|null
     */
    public function getItLog()
    {
        return $this->ItLog;
    }
    /**
     * Set ItLog value
     * @throws \InvalidArgumentException
     * @param \StructType\ItLog[] $itLog
     * @return \ArrayType\ArrayOfItLog
     */
    public function setItLog(array $itLog = array())
    {
        foreach ($itLog as $arrayOfItLogItLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfItLogItLogItem instanceof \StructType\ItLog) {
                throw new \InvalidArgumentException(sprintf('The ItLog property can only contain items of \StructType\ItLog, "%s" given', is_object($arrayOfItLogItLogItem) ? get_class($arrayOfItLogItLogItem) : gettype($arrayOfItLogItLogItem)), __LINE__);
            }
        }
        $this->ItLog = $itLog;
        return $this;
    }
    /**
     * Add item to ItLog value
     * @throws \InvalidArgumentException
     * @param \StructType\ItLog $item
     * @return \ArrayType\ArrayOfItLog
     */
    public function addToItLog(\StructType\ItLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItLog) {
            throw new \InvalidArgumentException(sprintf('The ItLog property can only contain items of \StructType\ItLog, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItLog
     */
    public function getAttributeName()
    {
        return 'ItLog';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
