<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriversLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriversLog extends AbstractStructArrayBase
{
    /**
     * The DriversLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DriversLog[]
     */
    public $DriversLog;
    /**
     * Constructor method for ArrayOfDriversLog
     * @uses ArrayOfDriversLog::setDriversLog()
     * @param \StructType\DriversLog[] $driversLog
     */
    public function __construct(array $driversLog = array())
    {
        $this
            ->setDriversLog($driversLog);
    }
    /**
     * Get DriversLog value
     * @return \StructType\DriversLog[]|null
     */
    public function getDriversLog()
    {
        return $this->DriversLog;
    }
    /**
     * Set DriversLog value
     * @throws \InvalidArgumentException
     * @param \StructType\DriversLog[] $driversLog
     * @return \ArrayType\ArrayOfDriversLog
     */
    public function setDriversLog(array $driversLog = array())
    {
        foreach ($driversLog as $arrayOfDriversLogDriversLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriversLogDriversLogItem instanceof \StructType\DriversLog) {
                throw new \InvalidArgumentException(sprintf('The DriversLog property can only contain items of \StructType\DriversLog, "%s" given', is_object($arrayOfDriversLogDriversLogItem) ? get_class($arrayOfDriversLogDriversLogItem) : gettype($arrayOfDriversLogDriversLogItem)), __LINE__);
            }
        }
        $this->DriversLog = $driversLog;
        return $this;
    }
    /**
     * Add item to DriversLog value
     * @throws \InvalidArgumentException
     * @param \StructType\DriversLog $item
     * @return \ArrayType\ArrayOfDriversLog
     */
    public function addToDriversLog(\StructType\DriversLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriversLog) {
            throw new \InvalidArgumentException(sprintf('The DriversLog property can only contain items of \StructType\DriversLog, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DriversLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DriversLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DriversLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DriversLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DriversLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DriversLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DriversLog
     */
    public function getAttributeName()
    {
        return 'DriversLog';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDriversLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
