<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCounterLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfCounterLog extends AbstractStructArrayBase
{
    /**
     * The CounterLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CounterLog[]
     */
    public $CounterLog;
    /**
     * Constructor method for ArrayOfCounterLog
     * @uses ArrayOfCounterLog::setCounterLog()
     * @param \StructType\CounterLog[] $counterLog
     */
    public function __construct(array $counterLog = array())
    {
        $this
            ->setCounterLog($counterLog);
    }
    /**
     * Get CounterLog value
     * @return \StructType\CounterLog[]|null
     */
    public function getCounterLog()
    {
        return $this->CounterLog;
    }
    /**
     * Set CounterLog value
     * @throws \InvalidArgumentException
     * @param \StructType\CounterLog[] $counterLog
     * @return \ArrayType\ArrayOfCounterLog
     */
    public function setCounterLog(array $counterLog = array())
    {
        foreach ($counterLog as $arrayOfCounterLogCounterLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfCounterLogCounterLogItem instanceof \StructType\CounterLog) {
                throw new \InvalidArgumentException(sprintf('The CounterLog property can only contain items of \StructType\CounterLog, "%s" given', is_object($arrayOfCounterLogCounterLogItem) ? get_class($arrayOfCounterLogCounterLogItem) : gettype($arrayOfCounterLogCounterLogItem)), __LINE__);
            }
        }
        $this->CounterLog = $counterLog;
        return $this;
    }
    /**
     * Add item to CounterLog value
     * @throws \InvalidArgumentException
     * @param \StructType\CounterLog $item
     * @return \ArrayType\ArrayOfCounterLog
     */
    public function addToCounterLog(\StructType\CounterLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CounterLog) {
            throw new \InvalidArgumentException(sprintf('The CounterLog property can only contain items of \StructType\CounterLog, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CounterLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CounterLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CounterLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CounterLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CounterLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CounterLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CounterLog
     */
    public function getAttributeName()
    {
        return 'CounterLog';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCounterLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
